/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_BUILTIN_H_
#define __XL_BUILTIN_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlexpr.h>
#include <xlclass.h>
#include <xlfield.h>
#include <xlmeth.h>
#include <xlmain.h>
#include <xllang.h>
#include <xloper.h>

extern XLClass* g_xl_builtin_current_class;
extern XString* g_xl_builtin_domain;

#define XL_ERROR printf
#define XL_ERR_BAD_EXPR   "ERROR('%s'): '%s' expression of bad type\n"

xvoid
xl_builtin_init ();

xvoid
xl_builtin_exit ();

/* Declarators
 */

xvoid
xl_builtin_domain (XLExpr* p_expr);

xvoid
xl_builtin_using (XLExpr* p_expr);

xvoid
xl_builtin_fnct (XLExpr* p_expr);

xvoid
xl_builtin_dlfnct (XLExpr* p_expr);

xvoid
xl_builtin_local (XLExpr* p_expr);

xvoid
xl_builtin_global (XLExpr* p_expr);

xvoid
xl_builtin_const (XLExpr* p_expr);


/* Class & Objects
 */

xvoid
xl_builtin_new (XLExpr* p_expr);

xvoid
xl_builtin_access (XLExpr* p_expr);

xvoid
xl_builtin_invoke (XLExpr* p_expr);

xvoid
xl_builtin_cast  (XLExpr* p_expr);


/* Language control
 */

xvoid
xl_builtin_import (XLExpr* p_expr);

xvoid
xl_builtin_array (XLExpr* p_expr);

xvoid
xl_builtin_array_add (XLExpr* p_expr);

xvoid
xl_builtin_array_get_size (XLExpr* p_expr);

xvoid
xl_builtin_array_set_size (XLExpr* p_expr);

#endif
