/* X Language - the eXtensible Language
 * Copyright (C) 2004 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xldataobject.h>

xvoid
xl_datavariant_destroy (XLDataVariant* variant)
{
  switch (XL_DATA (self)->type->type)
    {
    case XL_TYPE_TYPE_STRING:
      l_string = (XString*) (XL_DATA (self)->raw);
      x_unref (l_string);
      break;
    case XL_TYPE_TYPE_OBJECT:
      l_object = ((XLDataObject*) XL_DATA (self)->raw);
      if (l_object)
	{
	  l_object->refcount--;
	  if (l_object->refcount <= 0)
	    {
	      x_unref (l_object->class);
	      x_destroy (l_object->data);
	    }
	}
      x_destroy (l_object);
      break;
    default:
      if (XL_DATA (self)->raw)
	x_destroy (XL_DATA (self)->raw);
    }
}
