/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_EXPR_H_
#define __XL_EXPR_H_

#include <xldefs.h>

#define XL_EXPR(obj) ((XLExpr*) obj)

typedef enum {
	XL_EXPR_TYPE_NONE,
	XL_EXPR_TYPE_BLOCK,
	XL_EXPR_TYPE_DATA,
	XL_EXPR_TYPE_FNCT,
	XL_EXPR_TYPE_TYPE,
	XL_EXPR_TYPE_IDENTIFIER
} XLExprType;

struct _XLExpr
{
  XObject parent;

  XLExprType  expr_type;
  XLData*     data;
  XLFnct*     fnct;
  XLType*     type;
  XString*    identifier;
  xbool       check;
  
  XString*    source_file;
  xuint	      source_line;
  
  XList*      list_expr;
};

XLExpr*
xl_expr_new ();

XLExpr*
xl_expr_new_fnct (xstr l_fnct);

XLExpr*
xl_expr_new_identifier (xstr p_identifier);

xvoid
xl_expr_destroy (XObject* self);

xvoid
xl_expr_add (XLExpr* self, XLExpr* p_expr);

xvoid
xl_expr_evaluate (XLExpr* self);

xbool
xl_expr_check (XLExpr* self, XLExprType p_type);

XLExpr*
xl_expr_get (XLExpr* self, xuint p_index);

xuint
xl_expr_get_size (XLExpr* self);

xvoid
xl_expr_set_block (XLExpr* self);

xvoid
xl_expr_set_data (XLExpr* self, XLData* p_data);

xvoid
xl_expr_set_fnct (XLExpr* self, XString* p_name);

xvoid
xl_expr_set_type (XLExpr* self, XLType* p_type);

xvoid
xl_expr_set_identifier (XLExpr* self, XString* p_identifier);

xbool
xl_expr_read_integer (XLExpr* self, xuint index, xint* value);

xvoid
xl_expr_debug (XLExpr* self);

xvoid
xl_expr_load (XLExpr* self, XString* p_filename);

xvoid
xl_expr_save (XLExpr* self, XString* p_filename);

#endif
