/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xllang.h>
#include <xldata.h>
#include <xltype.h>
#include <xlexpr.h>
#include <parser/lisplike/xllanglisp.h>
#include <parser/basiclike/xllangbasic.h>
#include <parser/clike/xllangc.h>
#include <xllangpkg.h>

XLExpr*  g_lang_expr = NULL;
xuint    g_lang_line = 1;
xuint    g_lang_nberr;

XLExpr*  g_lang_call_stack[1000];
xuint    g_lang_call_num = 0;

XLExpr*  g_lang_block_stack[1000];
xuint    g_lang_block_num = 0;

XLExpr*  g_lang_fnct = NULL;
XLExpr*  g_lang_block = NULL;
XLExpr*  g_lang_call = NULL;
XLType*  g_lang_type = NULL;
XLData*  g_lang_data = NULL;
XString* g_lang_text = NULL;
XString* g_lang_filename = NULL;

XLExpr*  g_lang_class = NULL;

XString* g_lang_classname = NULL;

XLLang*
xl_lang_new (xstr p_filename)
{
  if (strncmp (p_filename + (strlen(p_filename) - 3), ".xb", 3) == 0)
    {
      return XL_LANG(xl_lang_basic_new ());
    }

  if (strncmp (p_filename + (strlen(p_filename) - 3), ".xc", 3) == 0)
    {
      return XL_LANG(xl_lang_c_new ());
    }

  if (strncmp (p_filename + (strlen(p_filename) - 3), ".xl", 3) == 0)
    {
      return XL_LANG(xl_lang_lisp_new ());
    }

  if (strncmp (p_filename + (strlen(p_filename) - 5), ".xpkg", 5) == 0)
    {
      return XL_LANG(xl_lang_pkg_new ());
    }

  return NULL;
}

xvoid
xl_lang_warning (xstr msg)
{
  printf ("warning: %s\n", msg);
}

xvoid
xl_lang_error (xstr msg)
{
  printf ("%s:%d: error: %s\n", x_string_get_str (g_lang_filename), g_lang_line, msg);
}

XLExpr*
xl_lang_type_create (XLTypeType p_type, XLTypeArrayType p_array, xuint p_size, XString* p_class)
{
  XLExpr* l_expr;
  XLType* l_type;

  l_type = xl_type_new (p_type, p_array, p_size, p_class);
  l_expr = xl_expr_new ();
  xl_expr_set_type (l_expr, l_type);
  x_unref (l_type);

  return l_expr;
}

xvoid
xl_lang_decl_add (XLExpr* p_expr)
{
  xl_expr_add (g_lang_expr, p_expr);
  x_unref (p_expr);
}

xvoid
xl_lang_class_create (XLExpr* p_identifier, XLExpr* p_parent)
{
  XLExpr*  l_parent;

  g_lang_class = xl_expr_new_fnct ("@class");

  x_unref (g_lang_classname);
  g_lang_classname = x_addref (XString, p_identifier->identifier);

  xl_expr_add (g_lang_class, p_identifier);
  x_unref (p_identifier);

  if (p_parent)
    l_parent = p_parent;
  else
    l_parent = xl_expr_new_identifier ("");

  xl_expr_add (g_lang_class, l_parent);
  x_unref (l_parent);
}

XLExpr*
xl_lang_class_finish ()
{
  return g_lang_class;
}

xvoid
xl_lang_class_add (XLExpr* p_expr)
{
  xl_expr_add (g_lang_class, p_expr);
  x_unref (p_expr);
}

xbool
xl_lang_class_check (xstr p_classname)
{
  if (g_lang_classname)
    if (x_string_cmp_str (g_lang_classname, p_classname)==0)
      return TRUE;
    else
      return FALSE;
  else
    return FALSE;
}

XLExpr*
xl_lang_data_string_create (xstr p_text)
{
  XLExpr*  l_expr;
  XLType*  l_type;
  XLData*  l_data;
  XString* l_text;
  xuint     i;

  l_text = x_string_new ();

  x_string_set_str (l_text, p_text);

  l_type = xl_type_new (XL_TYPE_TYPE_STRING, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);

  xl_data_set_string (l_data, l_text);
  x_unref (l_text);
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);
 
  x_unref (l_type);
  x_unref (l_data);
  
  return l_expr;
}

XLExpr*
xl_lang_data_char_create (xchar p_char)
{
  XLExpr* l_expr;
  XLType* l_type;
  XLData* l_data;

  l_type = xl_type_new (XL_TYPE_TYPE_CHAR, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);
  x_access (xl_data_get_raw (l_data), 0, xchar) = p_char;
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);

  x_unref (l_type);
  x_unref (l_data);

  return l_expr;
}

XLExpr*
xl_lang_data_integer_create (xint p_int)
{
  XLExpr* l_expr;
  XLType* l_type;
  XLData* l_data;

  l_type = xl_type_new (XL_TYPE_TYPE_UINT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);
  x_access (xl_data_get_raw (l_data), 0, xuint) = p_int;
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);

  x_unref (l_type);
  x_unref (l_data);

  return l_expr;
}

XLExpr*
xl_lang_data_float_create (xfloat p_value)
{
  XLExpr* l_expr;
  XLType* l_type;
  XLData* l_data;

  l_type = xl_type_new (XL_TYPE_TYPE_FLOAT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);
  x_access (xl_data_get_raw (l_data), 0, xfloat) = p_value;
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);

  x_unref (l_type);
  x_unref (l_data);

  return l_expr;
}

XLExpr*
xl_lang_data_bool_create (xbool p_bool)
{
  XLExpr* l_expr;
  XLType* l_type;
  XLData* l_data;

  l_type = xl_type_new (XL_TYPE_TYPE_BOOL, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);
  x_access (xl_data_get_raw (l_data), 0, xbool) = p_bool;
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);

  x_unref (l_type);
  x_unref (l_data);

  return l_expr;
}

XLExpr*
xl_lang_data_null_create ()
{
  XLExpr* l_expr;
  XLType* l_type;
  XLData* l_data;

  l_type = xl_type_new (XL_TYPE_TYPE_OBJECT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);

  x_unref (l_type);
  x_unref (l_data);

  return l_expr;
}

XLExpr*
xl_lang_efnct_create (xstr p_fnct)
{
  XLExpr* l_expr;

  l_expr = xl_expr_new_fnct (p_fnct);

  return l_expr;
}

XLExpr*
xl_lang_efnct_create1 (xstr p_fnct, XLExpr* p_expr1)
{
  XLExpr* l_expr;

  l_expr = xl_expr_new_fnct (p_fnct);
  xl_expr_add (l_expr, p_expr1);
  x_unref (p_expr1);

  l_expr->source_file = x_addref (XString, g_lang_filename);
  l_expr->source_line = g_lang_line;

  return l_expr;
}

XLExpr*
xl_lang_efnct_create2 (xstr p_fnct, XLExpr* p_expr1, XLExpr* p_expr2)
{
  XLExpr* l_expr;

  l_expr = xl_expr_new_fnct (p_fnct);

  xl_expr_add (l_expr, p_expr1);
  x_unref (p_expr1);
  xl_expr_add (l_expr, p_expr2);
  x_unref (p_expr2);

  l_expr->source_file = x_addref (XString, g_lang_filename);
  l_expr->source_line = g_lang_line;

  return l_expr;
}

XLExpr*
xl_lang_efnct_create3 (xstr p_fnct, XLExpr* p_expr1, XLExpr* p_expr2, XLExpr* p_expr3)
{
  XLExpr* l_expr;

  l_expr = xl_expr_new_fnct (p_fnct);

  xl_expr_add (l_expr, p_expr1);
  x_unref (p_expr1);
  xl_expr_add (l_expr, p_expr2);
  x_unref (p_expr2);
  xl_expr_add (l_expr, p_expr3);
  x_unref (p_expr3);

  l_expr->source_file = x_addref (XString, g_lang_filename);
  l_expr->source_line = g_lang_line;

  return l_expr;
}

XLExpr*
xl_lang_efnct_create4 (xstr p_fnct, XLExpr* p_expr1, XLExpr* p_expr2, XLExpr* p_expr3, XLExpr* p_expr4)
{
  XLExpr* l_expr;

  l_expr = xl_expr_new_fnct (p_fnct);

  xl_expr_add (l_expr, p_expr1);
  x_unref (p_expr1);
  xl_expr_add (l_expr, p_expr2);
  x_unref (p_expr2);
  xl_expr_add (l_expr, p_expr3);
  x_unref (p_expr3);
  xl_expr_add (l_expr, p_expr4);
  x_unref (p_expr4);

  l_expr->source_file = x_addref (XString, g_lang_filename);
  l_expr->source_line = g_lang_line;

  return l_expr;
}

xvoid
xl_lang_dlfnct_create (XLExpr* p_library, XLExpr* p_api, XLExpr* p_type, XLExpr* p_identifier)
{
  g_lang_fnct = xl_expr_new_fnct ("@dlfnct");

  xl_expr_add (g_lang_fnct, p_library);
  x_unref (p_library);

  xl_expr_add (g_lang_fnct, p_api);
  x_unref (p_api);

  xl_expr_add (g_lang_fnct, p_type);
  x_unref (p_type);

  xl_expr_add (g_lang_fnct, p_identifier);
  x_unref (p_identifier);
}

xvoid
xl_lang_fnct_create (XLExpr* p_type, XLExpr* p_identifier)
{
  g_lang_fnct = xl_expr_new_fnct ("@fnct");

  xl_expr_add (g_lang_fnct, p_type);
  x_unref (p_type);

  xl_expr_add (g_lang_fnct, p_identifier);
  x_unref (p_identifier);
}

xvoid
xl_lang_fnct_add_param (XLExpr* p_type, XLExpr* p_name)
{
  xl_expr_add (g_lang_fnct, p_type);
  x_unref (p_type);

  xl_expr_add (g_lang_fnct, p_name);
  x_unref (p_name);
}

xvoid
xl_lang_fnct_set_type (XLExpr* p_type)
{
 
}

xvoid
xl_lang_fnct_opt_param ()
{
  xl_expr_add (g_lang_fnct, NULL);
}

XLExpr*
xl_lang_fnct_finish (XLExpr* p_code)
{
  XLExpr* l_fnct;

  if (p_code)
    {
      xl_expr_add (g_lang_fnct, p_code);
      x_unref (p_code);
    }

  l_fnct = g_lang_fnct;
  g_lang_fnct = NULL;

  return l_fnct;
}

xvoid
xl_lang_method_create (XLExpr* p_type, XLExpr* p_identifier)
{
  g_lang_fnct = xl_expr_new_fnct ("@meth");

  xl_expr_add (g_lang_fnct, p_type);
  x_unref (p_type);
  xl_expr_add (g_lang_fnct, p_identifier);
  x_unref (p_identifier);
}

xvoid
xl_lang_method_static_create (XLExpr* p_type, XLExpr* p_identifier)
{
  g_lang_fnct = xl_expr_new_fnct ("@meth_static");

  xl_expr_add (g_lang_fnct, p_type);
  x_unref (p_type);
  xl_expr_add (g_lang_fnct, p_identifier);
  x_unref (p_identifier);
}

XLExpr*
xl_lang_method_finish (XLExpr* p_code)
{
  XLExpr* l_fnct;

  xl_expr_add (g_lang_fnct, p_code);
  x_unref (p_code);

  l_fnct = g_lang_fnct;
  g_lang_fnct = NULL;

  return l_fnct;
}

xvoid
xl_lang_block_begin ()
{
  if (g_lang_block)
    {
      g_lang_block_stack[g_lang_block_num] = g_lang_block;
      g_lang_block_num++;
    }
  g_lang_block = xl_expr_new_fnct ("@");
}

xvoid
xl_lang_block_add (XLExpr* p_expr)
{
  xl_expr_add (g_lang_block, p_expr);
  x_unref (p_expr);
}

XLExpr*
xl_lang_block_end ()
{
  XLExpr* l_block;

  if (g_lang_block_num > 0)
    {
      l_block = g_lang_block;
      g_lang_block_num--;
      g_lang_block = g_lang_block_stack[g_lang_block_num];
    }
  else
    {
      l_block = g_lang_block;
      g_lang_block = NULL;
    }

  return l_block;
}

xvoid
xl_lang_call_begin (xstr p_identifier)
{
  if (g_lang_call)
    {
      g_lang_call_stack[g_lang_call_num] = g_lang_call;
      g_lang_call_num++;
    }
  g_lang_call = xl_expr_new_fnct (p_identifier);

  g_lang_call->source_file = x_addref (XString, g_lang_filename);
  g_lang_call->source_line = g_lang_line;
}

xvoid
xl_lang_call_invoke_begin (XLExpr* p_expr, xstr p_identifier)
{
  XLExpr* l_identifier;

  if (g_lang_call)
    {
      g_lang_call_stack[g_lang_call_num] = g_lang_call;
      g_lang_call_num++;
    }
  g_lang_call = xl_expr_new_fnct ("::");

  xl_expr_add (g_lang_call, p_expr);
  x_unref (p_expr);

  l_identifier = xl_expr_new_identifier (p_identifier);
  xl_expr_add (g_lang_call, l_identifier);
  x_unref (l_identifier);
}

xvoid
xl_lang_call_add (XLExpr* p_expr)
{
  xl_expr_add (g_lang_call, p_expr);
  x_unref (p_expr);
}

XLExpr*
xl_lang_call_end ()
{
  XLExpr* l_call;

  if (g_lang_call_num > 0)
    {
      l_call = g_lang_call;
      g_lang_call_num--;
      g_lang_call = g_lang_call_stack[g_lang_call_num];
    }
  else
    {
      l_call = g_lang_call;
      g_lang_call = NULL;
    }

  return l_call;
}



