/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

/* CHANGES:
 *
 * - 06/03/2002 : HashTable support added by Xiong PuXiang (ffxz@gnuchina.org)
 */

#ifndef __XL_MAIN_H_
#define __XL_MAIN_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlist.h>
#include <xhash.h>

#include <xlfnct.h>
#include <xlvar.h>

#define XL_MAIN(obj) ((XLMain*) obj)

typedef struct _XLMain XLMain;
struct _XLMain
{
  XObject parent;

  /* HashTable support (see above)
   */

  XHashTable* globals;
  XHashTable* locals;
  XHashTable* functions;
  XHashTable* classes;

  XList*  list_stack;

  xbool   debugger;
};

extern XLMain* g_xl_main_global;

xvoid
xl_main_init ();

xvoid
xl_main_exit ();

XLMain*
xl_main_new ();

xvoid
xl_main_destroy (XObject* self);

xvoid
xl_main_print (XString* p_msg);

xvoid
xl_main_add_fnct_builtin (XLMain* self, xstr p_name, XLFnctBuiltin p_builtin);

XLFnct*
xl_main_add_fnct_native (XLMain* self, xstr p_name, xptr p_native);

XLFnct*
xl_main_add_fnct_expr (XLMain* self, xstr p_name, XLExpr* p_expr);

XLFnct*
xl_main_add_fnct_proto (XLMain* self, xstr p_name);

XLFnct*
xl_main_get_fnct (XLMain* self, XString* p_name);

xvoid
xl_main_add_var (XLMain* self, XLVar* p_var, xbool p_global);

XLVar*
xl_main_get_var (XLMain* self, XString* p_name);

xvoid
xl_main_add_class (XLMain* self, XLClass* p_class);

XLClass*
xl_main_get_class (XLMain* self, XString* p_name);

XHashTable*
xl_main_fnct_enter (XLMain* self, XLFnct* p_fnct);

xvoid
xl_main_fnct_leave (XLMain* self, XHashTable* p_hash);

xvoid
xl_main_warning (xstr msg);

xvoid
xl_main_error (xstr msg);

int
xl_main_main (int argc, char** argv);

#endif
