/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlmeth.h>
#include <xlmain.h>

XLMeth*
xl_meth_new (XString* p_name, XString* p_fnctname, XLMethType p_type)
{
  XLMeth *self;
  
  self = x_new (XLMeth);
  x_object_init_object (X_OBJECT (self), xl_meth_destroy);
  
  self->name = x_addref (XString, p_name);
  self->fnctname = x_addref (XString, p_fnctname);
  self->fnct = NULL;
  self->type = p_type;
  
  return self;
}

xvoid
xl_meth_destroy (XObject* self)
{
  x_unref (XL_METH (self)->name);
  x_unref (XL_METH (self)->fnct);
  x_unref (XL_METH (self)->fnctname);

  x_destroy (self);
}

XLFnct*
xl_meth_get_fnct (XLMeth* self)
{
  if (self->fnct)
    return self->fnct;
  else
    {
      self->fnct = xl_main_get_fnct (g_xl_main_global, self->fnctname);
      return self->fnct;
    }
}


