/* XLanguage - the eXtensible Language
 * Copyright (C) 2004 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xloper.h>

xvoid
xl_oper_create (XLOper* oper, XLExpr* expr)
{
  XLExpr* subexpr;

  subexpr = XL_EXPR (x_list_get (expr->list_expr, 0));
  xl_expr_evaluate (subexpr);

  switch (subexpr->data->type->type)
    {
    case XL_TYPE_TYPE_INT:
    case XL_TYPE_TYPE_UINT:
      oper->type = XL_OPER_TYPE_INT;
      oper->operands[0].vint = x_access (xl_data_get_raw (subexpr->data), 0, xint);
      break;
    case XL_TYPE_TYPE_FLOAT:
      oper->type = XL_OPER_TYPE_FLOAT;
      oper->operands[0].vfloat = x_access (xl_data_get_raw (subexpr->data), 0, xfloat);
      break;
    default:
      xl_main_error ("xl_oper_create");
    }
  x_unref (subexpr);

  subexpr = XL_EXPR (x_list_get (expr->list_expr, 1));
  if (subexpr)
    {
      xl_expr_evaluate (subexpr);
      switch (subexpr->data->type->type)
	{
	case XL_TYPE_TYPE_INT:
	case XL_TYPE_TYPE_UINT:
	  oper->type = XL_OPER_TYPE_INT;
	  oper->operands[1].vint = x_access (xl_data_get_raw (subexpr->data), 0, xint);
	  break;
	case XL_TYPE_TYPE_FLOAT:
	  oper->type = XL_OPER_TYPE_FLOAT;
	  oper->operands[1].vfloat = x_access (xl_data_get_raw (subexpr->data), 0, xfloat);
	  break;
	default:
	  xl_main_error ("xl_oper_create");
	  break;
	}
      x_unref (subexpr);
    }
}

xvoid
xl_oper_return (XLOper* oper, XLData** data)
{
  switch (oper->type)
    {
    case XL_OPER_TYPE_INT:
      if (*data)
	x_access (data, 0, xint) = oper->value.vint;
      else
	*data = xl_data_new_integer (oper->value.vint);
      break;
    case XL_OPER_TYPE_BOOL:
      if (*data)
	x_access (data, 0, xbool) = oper->value.vbool;
      else
	*data = xl_data_new_boolean (oper->value.vbool);
      break;
    }
}









