/* XLanguage - the eXtensible Language
 * Copyright (C) 2004 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_OPER_H_
#define __XL_OPER_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xldata.h>
#include <xltype.h>

typedef enum 
{
  XL_OPER_TYPE_INT,
  XL_OPER_TYPE_FLOAT,
  XL_OPER_TYPE_DOUBLE,
  XL_OPER_TYPE_BOOL
} XLOperType;

typedef union _XLOperData XLOperData;
union _XLOperData
{
  xint     vint;
  xfloat   vfloat;
  xdouble  vdouble;
  xbool    vbool;
};

typedef struct _XLOper XLOper;
struct _XLOper
{
  XLOperType type;
  XLOperData value;
  XLOperData operands[2];
};

xvoid
xl_oper_create (XLOper* oper, XLExpr* expr);

xvoid
xl_oper_return (XLOper* oper, XLData** data);

xvoid
xl_oper_convert (XLOperData value);

#endif


