/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <io/xiofile.h>

xptr
x_io_file_open (XString* filename, xuint mode)
{
  char* omode;
  xbool oread;
  xbool owrite;
  xbool ocreate;

  if ((mode & X_IO_FILE_CREATE) == X_IO_FILE_CREATE) ocreate = TRUE; else ocreate = FALSE;
  if ((mode & X_IO_FILE_WRITE) == X_IO_FILE_WRITE) owrite = TRUE; else owrite = FALSE;
  if ((mode & X_IO_FILE_READ) == X_IO_FILE_READ) oread = TRUE; else oread = FALSE;

  if (ocreate)
    {
      if (owrite && oread)
	omode = "w+";
      else
	omode = "w";
    }
  else
    {
      if (owrite && oread)
	omode = "r+";
      else
	omode = "r";
  }

  return (xptr) fopen (x_string_get_str (filename), omode);
}

xvoid
x_io_file_close (xptr fileid)
{
  fclose (fileid);
}

xvoid
x_io_file_write (xptr fileid, XString* text)
{
  fwrite (x_string_get_str (text), x_string_get_size (text), 1, fileid);
}

xvoid 
x_io_file_read (xptr fileid, XString* text, xuint size)
{
  x_string_set_size (text, size);
  fread (text->data, size, 1, fileid);
}

xbool
x_io_file_is_eof (xptr fileid)
{
  return (xbool) feof ((FILE*) fileid);
}

xuint
x_io_file_get_pos (xptr fileid)
{
  return ftell (fileid);
}

xuint 
x_io_file_set_pos (xptr fileid, xuint pos)
{
  fseek (fileid, pos, SEEK_SET);
}

xuint
x_io_file_get_size (xptr fileid)
{
  xuint pos;
  xuint size;

	if (fileid == NULL)
		return 0;	
  pos = x_io_file_get_pos (fileid);
  fseek (fileid, 0, SEEK_END);
  size = ftell (fileid);
  x_io_file_set_pos (fileid, pos);

  return size;
}
