/* X Language - the eXtensible Language
 * Copyright (C) 2002 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <scr/xscr.h>

#ifdef HAVE_OS_WIN32
#include <windows.h>
#endif

xvoid
x_scr_init ()
{
}

xvoid
x_scr_exit ()
{
}

xvoid
x_scr_clear ()
{
}

xvoid
x_scr_write (XString* data)
{
#ifdef HAVE_OS_WIN32
  DWORD dw;
  WriteConsole (GetStdHandle (STD_OUTPUT_HANDLE), x_string_get_str (data), data->size, &dw, NULL);
#endif
}

xvoid
x_scr_gotoxy (xuint x, xuint y)
{
#ifdef HAVE_OS_WIN32
  COORD coord;

  coord.X = x;
  coord.Y = y;
  SetConsoleCursorPosition (GetStdHandle (STD_OUTPUT_HANDLE), coord);
#endif
}

xuint
x_scr_get_width ()
{
}

xuint 
x_scr_get_height ()
{
}

xvoid 
x_scr_set_fgcolor (xuint color)
{
}

xvoid 
x_scr_set_bgcolor (xuint color)
{
}
