/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <wnd/x11/xwnd-x11.h>
#include <xlist.h>

Display* g_display;

xbool
x_wnd_window_init ()
{
  g_window_list = x_list_new ();
  g_display = XOpenDisplay(NULL);

  if (!g_display)
    printf ("Unable to connect to DISPLAY\n");
}

XWndWindow*
x_wnd_window_open (xstr title, xint x, xint y, xuint w, xuint h, XWndWindow* parent)
{
  XWndWindow* window;

  if (!g_display)
    return NULL;

  window = x_wnd_window_new ();

  if (parent)
    {
      window->native_window = (xptr) XCreateSimpleWindow (g_display, (Window) parent->native_window,
							  x, y, w, h,
							  0, 0, 0x7F7F7F);
    }
  else
    {
      window->native_window = (xptr) XCreateSimpleWindow (g_display, RootWindow(g_display, 0), 
							  x, y, w, h,
							  0, 0, 0xAFAFAF);
    }

  XSelectInput (g_display, (Window) window->native_window, ExposureMask | KeyPressMask | ButtonPressMask);
  XFlush (g_display);

  x_list_add (g_window_list, X_OBJECT (window));

  return window;
}

xvoid
x_wnd_window_close (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_pos (XWndWindow* self, xint x, xint y)
{
}

xint
x_wnd_window_get_pos_x (XWndWindow* self)
{
}

xint
x_wnd_window_get_pos_y (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_size (XWndWindow* self, xuint w, xuint h)
{
}

xuint
x_wnd_window_get_size_w (XWndWindow* self)
{
}

xuint
x_wnd_window_get_size_h (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_show (XWndWindow* self, xbool is_show)
{
  if (is_show)
    XMapWindow (g_display, (Window) self->native_window);
}

xbool
x_wnd_window_get_show (XWndWindow* self)
{
}

xvoid
x_wnd_window_redraw (XWndWindow* self)
{
}

XWndGC*
x_wnd_window_get_gc (XWndWindow* self)
{
  XWndGC* gc;

  gc = x_wnd_gc_new ();
  gc->window = x_addref (XWndWindow, self);
  gc->native_gc = XCreateGC (g_display, (Window) self->native_window, 0, 0);

  return gc;
}

xvoid
x_wnd_window_release_gc (XWndWindow* self, XWndGC* gc)
{
  XFreeGC (g_display, (GC) gc->native_gc);
}

XWndWindow*
x_wnd_window_get_parent (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_parent (XWndWindow* self, XWndWindow* parent)
{
  XReparentWindow (g_display, (Window) self->native_window, (Window) parent->native_window, 0, 0);
}

xstr
x_wnd_window_get_title (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_title (XWndWindow* self, xstr title)
{
}
