/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __X_WND_EVENT_H_
#define __X_WND_EVENT_H_

#include <xdefs.h>
#include <xobject.h>

#define X_WND_EVENT(obj) ((XWndEvent*) obj)

typedef unsigned int (*XWndEventCallback) (XWndEvent* evt);

typedef enum
  {
    XWND_EVENT_UNKNOWN,
    
    XWND_EVENT_WINDOW_PAINT,
    XWND_EVENT_WINDOW_MOVE,
    XWND_EVENT_WINDOW_SIZE,
    XWND_EVENT_WINDOW_CLOSE,

    XWND_EVENT_MOUSE_ENTER,
    XWND_EVENT_MOUSE_LEAVE,
    XWND_EVENT_MOUSE_MOVE,
    XWND_EVENT_MOUSE_DOWN,
    XWND_EVENT_MOUSE_UP,

    XWND_EVENT_KEY_DOWN,
    XWND_EVENT_KEY_UP
  } 
XWndEventType;

struct _XWndEvent
{
  XObject       parent;
  XWndEventType message;
  XWndWindow*   window;
  xint          x, y;
  xint          w, h;
};

extern XWndEventCallback g_wnd_event_callback;

XWndEvent*
x_wnd_event_new ();

xvoid
x_wnd_event_destroy (XObject* self);

xptr
x_wnd_event_get ();

xvoid
x_wnd_event_register (XWndEventCallback callback);

#endif
