# loadxpcomp.sh - loads xpcomp into the current bash (for debugging only) 
#
#  Copyright (C) 2001 Ingo K"ohne
#  
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

help ()
{
    cat <<EOF
 init script to be used from the top level source dir 
 to build a temporary cache file from the completions in scripts/completions
 and enable them in the current bash

 either call 'source gdb/loadxpcomp' in an already running bash
 or start a new one with 'bash --rcfile gdb/loadxpcomp'.
 options can be given on the 'source' command line or via the
 LOADXPCOMP_OPTS environment variable when using the --rcfile option.

 options:
 -e <script>  eval a script snippet before building the completion cache 
	       (usefull to give control back to gdb to set breakpoints ...)
 -p <prompt>  set PS1 to <prompt>
 -q           quiet
 -C <file>    name of temporary cache file
              
 some options that need only to be set if this script is not started from the
 top level source directory:
 -D <directory> switch to this directory before building the cache.
              If this option is given and any of the following option
              have a relative path as a parameter, it is relative to this
              directory.
 -c <file>    directory containing completion script snippets
 -S <file>    location of xpcomp_setup script
 -U <file>    location of xpcomp_update script
 -X <file>    location of xpcomp shared object file
EOF
}

cache=/tmp/cache$$
xpcomp_setup=scripts/xpcomp_setup.sh
xpcomp_updatecache=scripts/xpcomp_updatecache
export XPCOMP_SO=xpcomp.so

loadxpcomp_message ()
{
    if test $quiet -eq 1; then return 0; fi
    echo "loadxpcomp: $*"
}

die ()
{
    echo "$@" >&2
    exit 1
}

loadxpcomp_cleanup ()
{
    if test -f "$cache"; then
	loadxpcomp_message "removing temporary cache file $cache"
	rm -f "$cache"
    fi
}
trap loadxpcomp_cleanup EXIT

declare -i stop_bash=0
declare -i quiet=0

if test -n "$LOADXPCOMP_OPTS"; then
    loadxpcomp_message "got options through environment: $LOADXPCOMP_OPTS"
    eval set -- $LOADXPCOMP_OPTS
fi

while getopts "he:qp:C:X:c:U:S:D:" option
do
    case $option in
    e)  eval_script="${eval_script+$eval_script;}$OPTARG" ;;
    p)	case ${-} in *i*) PS1="$OPTARG"; esac ;;
    D)  newdir="$OPTARG" ;;
    C)  cache="$OPTARG" ;;
    c)  scriptdir="$OPTARG" ;;
    X)	XPCOMP_SO="$OPTARG" ;;
    S)	xpcomp_setup="$OPTARG" ;;
    U)	xpcomp_updatecache="$OPTARG" ;;
    q)	quiet=1	;;
    h)	help; exit 0 ;;
    esac
done

if test -n "$newdir"; then
    test -d "$newdir" || die "No such directory: $newdir"
    olddir=$(pwd)
    cd $newdir
fi

test -f "$XPCOMP_SO" || die "No such file: $XPCOMP_SO"
# make absolute pathname for XPCOMP_SO
if test $(dirname $XPCOMP_SO) = . ;then
    if test -n "$newdir"; then
	XPCOMP_SO=$newdir/$XPCOMP_SO
    else
	XPCOMP_SO=$(pwd)/$XPCOMP_SO
    fi
fi
enable -f $XPCOMP_SO xpcomp
enable -f $XPCOMP_SO optcomplete
enable -f $XPCOMP_SO xpcompcore

test -n "$eval_script" && eval "$eval_script"

if test -d "$scriptdir"; then
	test -f "$xpcomp_updatecache" || die "No such file: $xpcomp_updatecache"
	test -f "$xpcomp_setup" || die "No such file: $xpcomp_setup"
	test -d "$(dirname $cache)" || die "No such file: $(dirname $cache)"

	loadxpcomp_message "building cache file $cache from $scriptdir"
	# unset variables will be errors
	set -u
	source "$xpcomp_updatecache" -C "$cache" -c "$scriptdir"
	set +u

	loadxpcomp_message "loading cache file $cache"
	source "$xpcomp_setup" "$cache"
else
	loadxpcomp_message "No script directory configured, not building cache"
fi

if test -n "$newdir"; then
    cd $olddir
fi


unset cache scriptdir xpcomp_setup xpcomp_updatecache XPCOMP_SO olddir newdir

