#! /bin/sh

die ()
{
    echo -e "$@" >&2
    exit 1
}

CONFIG_AUX_DIR=support
CONFIG_AUX_FILES='config.sub config.guess install.sh shobj-conf'


for file in $CONFIG_AUX_FILES; do
    test $CONFIG_AUX_DIR && file=$CONFIG_AUX_DIR/$file
    test -f $file && continue
    case $file in
    *config.sub|*config.guess)
	if ! cp -v /usr/share/misc/$(basename $file) $file 2>/dev/null; then
	    die "missing file: $file.\nRecent version is in the debian autotools-dev package"
	fi
	;;
    *install.sh)
	die "Missing file: $file.\nTry fetch from automake. Sometimes also named install-sh."
	;;
    *shobj-conf)
	die "Missing file: $file.\nTry fetch from bash sources."
	;;
    esac
done

autoconf
