/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  

  

#include "xrebind.h"


int
grab_all_data (xrb_prog_data *xd, int grab)
{
  int i=0;
  int button_mask = 0;

  xrb_verbose (" ---> grab_all_data\n");


  for (i=0; i<xd->gdl_size ; i++)
    {
      if (grab)
	{      
	  verbose_gd ( xd->grab_data_list[i]);
	  if ( xd->grab_data_list[i]->code != 0) 
	    {
	      set_no_repeat ( xd->grab_data_list[i]->code , 
			      xd->grab_data_list[i]->autorepeat);
	      xrb_verbose ("XGrabKey (disp=%d,window=%d,"
			   "code=%d,modifier=%d)\n",
			   xd->data_display,  
			   xd->window,  
			   xd->grab_data_list[i]->code,           
			   xd->grab_data_list[i]->modifier);
	      
	      
	      XGrabKey (xd->data_display,  
			xd->grab_data_list[i]->code,           
			xd->grab_data_list[i]->modifier,
			xd->window,       
			False,        
			GrabModeAsync,
			GrabModeAsync );
	    }
	  else
	    {

	      switch  (xd->grab_data_list[i]->button)
		{
		case 1:
		  button_mask = Button1Mask ;
		  break;
		case 2:
		  button_mask = Button2Mask ;
		  break;
		case 3:
		  button_mask = Button3Mask ;
		  break;
		case 4:
		  button_mask = Button4Mask ;
		  break;
		case 5:
		  button_mask = Button5Mask ;
		  break;
		case 6:
		  button_mask = Button6Mask ;
		  break;
		default:
		  button_mask = Button1Mask | Button2Mask | Button3Mask | Button4Mask | Button5Mask | Button6Mask ;
		  break;
		}

	      xrb_verbose ("XGrabButton (disp=%d,window=%d"
			   ",button=%d (mask=%d),modifier=%d)\n",
			   xd->data_display,   xd->window,
			   xd->grab_data_list[i]->button, button_mask,           
			   xd->grab_data_list[i]->modifier );

	      XGrabButton (xd->data_display,                /* Display */
			   xd->grab_data_list[i]->button,   /* Button */
			   xd->grab_data_list[i]->modifier, /* Modifier */
			   xd->window,                      /* Window */
			   False,                           /* owner_events */
			   button_mask,                     /* Event mask */
			   GrabModeAsync,                   /* Pointer mode */
			   GrabModeAsync,                   /* Keyboard mode */
			   None,                            /* confine to */ 
			   None                             /* Curosor to  */);
	    }
	}
      else 
	{      
	  if ( xd->grab_data_list[i]->code != 0) 
	    {
	      xrb_verbose ("XUngrabKey (disp=%d,code=%d,"
			   "modifier=%d,window=%d\n",
			   xd->data_display,  
			   xd->grab_data_list[i]->code,           
			   xd->grab_data_list[i]->modifier,
			   xd->window);
	      
	      
	      XUngrabKey (xd->data_display,  
			  xd->grab_data_list[i]->code,           
			  xd->grab_data_list[i]->modifier,
			  xd->window);
	    }
	  else
	    {
	      xrb_verbose ("XUngrabButton (disp=%d,window=%d,"
			   "button=%d,modifier=%d)\n",
			   xd->data_display,  
			   xd->window,  
			   xd->grab_data_list[i]->button,           
			   xd->grab_data_list[i]->modifier);
	      XUngrabButton (xd->data_display,  
			     xd->grab_data_list[i]->button,           
			     xd->grab_data_list[i]->modifier,
			     xd->window);
	      
	    }
	  
	}
    }
  xrb_verbose (" <--- grab_all_data\n");
  return 1;
}


