/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */

#include "xrebind.h"
#include "parse.h"

xrb_prog_data *xrb_data;

int main (int argc,char *argv[])
{
  int ret ; 

  (void) signal (SIGINT,  xrb_signal_handler);

  xrb_data = xrb_new_xrb_prog_data();
  if (xrb_data==NULL)
    {
      exit(XREBIND_ALLOC_FAILED);
    }  
  
  if ( xrb_parse_args (xrb_data, argc, argv))
    {
      exit(XREBIND_PARSE_FAILED);
    }

  if ( xrb_setup(xrb_data)) 
    {
      exit(XREBIND_SETUP_FAILED);
    }

  xrb_main_loop(xrb_data);

  xrb_close_down(xrb_data);
  return 0;
}






