/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  



#include "xrebind.h"
#include "xrb_session.h"
#include "xrb_feedback.h"

void
xrb_main_loop(xrb_prog_data *xd)
{
  int    x_dir, y_dir;
  XEvent my_event ;
  
  int    j = 0 ;
  int    i = 0 ;

  xrb_print_settings( xrb_data );

  for (;;)
    {
      
      xrb_verbose ("main_loop: Waiting for an event\n");
      XNextEvent (xrb_data->data_display, &my_event);
      xrb_verbose ("           received a new event \n");
      if (my_event.xkey.send_event==1) 
	{ 
	  fprintf (stderr, "the event received has the send_event flag set\n");
	}
      
      xrb_action_handler(xd, &my_event);
    }
}



void 
xrb_close_down(xrb_prog_data *xd)
{
  int i=0;

  if ( xd->gdl_size != 0 ) 
    {
      xrb_verbose ("Grab Data list size %d\n",xd->gdl_size);
      
      xrb_verbose ("Ungrabbing keys\n");
      grab_all_data (xd, 0);
      
  
      for (i=0;i<xd->gdl_size;i++)
	{
	  if ( xd->grab_data_list[i]->autorepeat==XREBIND_REPEAT_ON ) 
	    {
	      if ( xd->grab_data_list[i]->code != 0 )
		{
		  xrb_verbose ("Turning on autorepeat on key %d at grab list %d\n",
			       xd->grab_data_list[i]->code , i );
		  set_no_repeat ( xd->grab_data_list[i]->code , 
				  XREBIND_REPEAT_ON);
		}
	    }
	}  
      
      
      xrb_verbose ("Freeing memory\n");
      for (i=0;i<xd->gdl_size;i++)
	{
	  xrb_verbose ("  at position = %d  (%d)", i, xd->grab_data_list[i]);
	  free(xd->grab_data_list[i]);
	  xrb_verbose ("  ok\n");
	}
    }

      xrb_verbose ("  whole struct\n");
      free (xd->grab_data_list);
      xrb_verbose ("  whole struct freed\n");
      fflush (stderr);
#ifdef HAVE_XOSD
  if (osd!=NULL)
    {
      xrb_verbose ("  destroying xosd %d\n", osd);
      xosd_destroy(osd);
      xrb_verbose ("  destroying xosd ok\n");
      fflush (stderr);
    }
#endif
  xrb_verbose ("<--- xrb_close_down\n");
}


void 
init_type( grab_data *gd)
{
  gd->button             = 0;
  gd->code               = 0;
  gd->fake_release       = 0;
  gd->fake_release_delay = 0;

  if (gd->type==XREBIND_EXEC) 
    { 
      gd->autorepeat     = XREBIND_REPEAT_OFF;
      strcpy(gd->xrb_action.ea.command_line,""); 
    }
  else if (gd->type==XREBIND_MOTION ) 
    { 
      gd->autorepeat     = XREBIND_REPEAT_ON;
      gd->xrb_action.ma.speed=1;
      gd->xrb_action.ma.x_direction=XREBIND_NO_MOTION;
      gd->xrb_action.ma.y_direction=XREBIND_NO_MOTION;
    }
  else if (gd->type==XREBIND_BUTTON ) 
    { 
      gd->autorepeat     = XREBIND_REPEAT_OFF;
      gd->xrb_action.ba.double_click=XREBIND_SINGLE_CLICK;
    }
  else if (gd->type==XREBIND_KEY ) 
    { 
      gd->autorepeat     = XREBIND_REPEAT_ON;
    }
}




int
xrb_setup(xrb_prog_data* xrb_data)
{
  int ret ; 

#ifdef HAVE_XOSD
  osd = xosd_create(2);
  if (osd!=NULL)
    {
      if (xrb_data->xosd_font==NULL)
	{
	  xosd_set_font(osd, 
			"-adobe-helvetica-bold-r-normal-*-*-320-*-*-p-*-iso8859-1");
	}
      else
	{
	  xosd_set_font(osd, xrb_data->xosd_font);
	}
      xosd_set_timeout(osd, 2);
      xosd_set_pos(osd, XOSD_bottom);
      xosd_set_shadow_offset(osd, 4);
    }
#endif

  xrb_data->data_display = XOpenDisplay(xrb_data->display_name);
  if (xrb_data->data_display == NULL) 
    {
      xrb_error ("Could not open display ... \n");
      return XREBIND_DISPLAY_FAILED;
    }
  xrb_data->screen = DefaultScreen (xrb_data->data_display);
  xrb_data->window = RootWindow(xrb_data->data_display, xrb_data->screen);

  xrb_open_rc_file (xrb_data);
  if (xrb_data->fd==NULL)
    {
      xrb_error ("Couldn't find any rc file or any comand line option\n");
      return XREBIND_RC_ERROR;
    }
  

  add_all_data (xrb_data);
  
  fclose(xrb_data->fd);
  
  grab_all_data (xrb_data,1);

  ret = XTestGrabControl ( xrb_data->data_display , True);
  if (ret!=1) 
    {
      xrb_error ("Could not grab display\n");
      exit (XREBIND_NOT_GRAB);
    }

  return 0;
}

