/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */


#include "xrebind.h"
#include "config.h"


static char *xrb_help[]=
  {
    PACKAGE " - maps keys (with modifiers) to:",
    "\tmouse motion",
    "\tbutton press/release",
    "\tkey press/release",
    "\tlaunch program",
    NULL
  };

static char *xrb_description[]=
  {
    PACKAGE "grabs keys as specified in ithe rc file. These keys", 
    "are mapped to either a mouse button click or mouse motion",
    NULL
  };


static char *xrb_example[]=
  {
    ".... examples are coming soon",
    NULL
  };

static char *xrb_files[]=
  {
    PACKAGE "read files in the following order:",
    "\tgiven by environment variable: " PROGRAM_RC_ENV ,
    "\t" XREBIND_LOCAL_RC,
    "\t" XREBIND_SYSTEM_RC,
    NULL
  };

static char *xrb_file_syntax[]=
  {
    " ... se example xrbrc as delivered in this package",
    NULL
  };

static char *xrb_options[]=
  {
    "--display <name>, -d <name>" , "display to connect to",
    "--verbose, -v",                "set verbose mode",
    "--help, -h",                   "prints this help printout",
    "--version, -V",                "prints version number",
    "--file, -f <file>",            "Read settings from <file> ",
    "--xosd-font, -xf <font>",      "Use <font> for xosd feedback",
    NULL
  };

void 
xrb_usage ()
{

  fprintf (stdout, "NAME\n ");
  xrb_print_chars (xrb_help);
  fprintf (stdout, "\n");

  fprintf (stdout, "DESCRIPTION\n");
  xrb_print_chars (xrb_description);
  fprintf (stdout, "\n");

  fprintf (stdout, "OPTIONS\n");
  xrb_print_opt_chars (xrb_options);
  fprintf (stdout, "\n");

  fprintf (stdout, "RESOURCE FILES\n");
  xrb_print_chars (xrb_files);
  fprintf (stdout, "\n");

  fprintf (stdout, "RESOURCE FILE SYNTAX\n");
  xrb_print_chars (xrb_file_syntax);
  fprintf (stdout, "\n");

  fprintf (stdout, "EXAMPLE\n");
  xrb_print_chars (xrb_example);
  fprintf (stdout, "\n");
}




/**
 *
 * Parse the command line
 *
 */
int 
xrb_parse_args ( xrb_prog_data *xd, int argc, char **argv)
{
  int i ;
  for (i = 1; i < argc; i++) 
    {
      if( xrb_check (argv[i], "--verbose", "-v"  ) )
	{
	  xd->verbose=1;
	  continue;
	}
      else if( xrb_check (argv[i], "--display", "-d"  ) )
	{
	  xd->display_name=argv[++i];
	  continue;
	}
      else if( xrb_check (argv[i], "--version", "-V"  ) )
	{
	  xrb_version();
	  exit(0);
	}
      else if( xrb_check (argv[i], "--help", "-h"  ) )
	{
	  xrb_usage();
	  exit(0);

	}
      else if( xrb_check (argv[i], "--file", "-f"  ) )
	{
	  xrb_data->cli_rc = argv[i+1] ;
	  i++;
	}
      else if( xrb_check (argv[i], "--xosd-font", "-xf"  ) )
	{
	  xrb_set_xosd_font(xd,argv[i+1]);
	  i++;
	}
      else 
	{
	  fprintf (stderr, "Could not parse arg: \"%s\""
		   "\n...skipping the arg continuing\n", argv[i]);
	  i++;
	}
    }
  return 0;
}



