<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet  version="1.0" 
                 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="items">
        <html>
            <head>
                <link rel="stylesheet" href="list.css" type="text/css"/>
            </head>
            <body>
                <div style="display: none;">
                    <xsl:copy-of select="$http"/>
                </div>
                <h1>Bookmarks</h1>
                <xsl:choose>
                    <xsl:when test="not(item)">
                        <div>No bookmarks yet</div>
                    </xsl:when>
                    <xsl:otherwise>
                        <ul>
                            <xsl:for-each select="item">
                                <li><xsl:value-of select="."/></li>
                            </xsl:for-each>
                        </ul>
                    </xsl:otherwise>
                </xsl:choose>
                <form method="POST" action="/">
                    <fieldset>
                        <label>Title</label><input type="text" name="title" value=""/><br/>
                        <label>Href</label><input type="text" name="href" value=""/><br/>
                        <label>Keyword</label><input type="text" name="keyword" value=""/><br/>
                        <input type="submit" name="add" value="add"/>
                    </fieldset>
                </form>
            </body>
        </html>
    </xsl:template>

</xsl:stylesheet>
