<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet  version="1.0"
                 xmlns:http="http://www.tapsellferrier.co.uk/namespace/xslt_http_ns"
                 xmlns:python="http://www.tapsellferrier.co.uk/xslt-dynamic-function-languages/python"
                 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                 xsl:exclude-result-prefixes="python">

    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes" />

    <xsl:include href="bookmark-created.xslt"/>
    <xsl:include href="bookmark-list.xslt"/>

    <xsl:template match="/">
        <xsl:apply-templates select="/http:request"/>
    </xsl:template>

    <!-- List all the records -->
    <xsl:template match="http:request[http:method = 'GET']">
        <xsl:variable name="bookmarks" select="python:bookmark.listall()"/>
        <xsl:apply-templates select="$bookmarks">
            <xsl:with-param name="http" select="/http:request"/>
        </xsl:apply-templates>
    </xsl:template>

    <!-- Create new records -->
    <xsl:template match="http:request[http:method = 'POST']">
        <xsl:variable name="toadd" select="//http:parameter[http:name = 'href']/http:value"/>
        <xsl:variable name="updated" select="python:bookmark.add(string($toadd))"/>
        
        <xsl:apply-templates select="$updated" mode="created">
            <xsl:with-param name="statuscode">201</xsl:with-param>
            <xsl:with-param name="toadd" select="$toadd"/>
            <xsl:with-param name="request" select="/http:request"/>
        </xsl:apply-templates>
    </xsl:template>


</xsl:stylesheet>
