<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet  version="1.0"
                 xmlns:http="http://www.tapsellferrier.co.uk/namespace/xslt_http_ns"
                 xmlns:python="http://www.tapsellferrier.co.uk/xslt-dynamic-function-languages/python"
                 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                 xsl:exclude-result-prefixes="python">

    <xsl:import href="http.xslt"/>

    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes" />

    <xsl:include href="bookmark-common.xslt"/>
    <xsl:include href="bookmark-created.xslt"/>
    <xsl:include href="bookmark-list.xslt"/>

    <!-- List all the records -->
    <xsl:template match="/http:request[http:uri='/' and http:method = 'GET']">
        <xsl:variable name="bookmarks" select="python:bookmark.listall()"/>
        <xsl:apply-templates select="$bookmarks">
            <xsl:with-param name="http" select="/http:request"/>
        </xsl:apply-templates>
    </xsl:template>

    <!-- Create new records -->
    <xsl:template match="/http:request[http:method = 'POST']">
        <xsl:variable name="href" select="string(//http:parameter[http:name = 'href']/http:value)"/>
        <xsl:variable name="title" select="string(//http:parameter[http:name = 'title']/http:value)"/>
        <xsl:variable name="keywords" select="string(//http:parameter[http:name = 'keywords']/http:value)"/>
        <xsl:variable name="new_rec" select="python:bookmark.add($href, $keywords, $title)"/>
        
        <xsl:apply-templates select="$new_rec" mode="created">
            <xsl:with-param name="statuscode">201</xsl:with-param>
            <xsl:with-param name="request" select="/http:request"/>
        </xsl:apply-templates>
    </xsl:template>

</xsl:stylesheet>
