#!/usr/bin/python

# A simple gadfly db example for XRT/XSLTpages
# Copyright (C) 2006 by Tapsell-Ferrier Limited

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc.,   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA



# This is an example of how to do db stuff... not how to write an issue tracker
# It could be cleaned up a lot. Suggestions:

# - add a date column on the issue table
# - add a status column to the issue table
# - search
# - add an adjunct to an issue (this is why id and issueid are separate)


import gadfly
import datetime
import os
import os.path
import re
import sys


db_name = "issue_tracker"

def get_con(db_name, base=os.getcwd() + "/dbtest"):
    """return a connection, maybe init the db first"""

    if not os.path.exists(base):
        os.mkdir(base)
        connection = gadfly.gadfly()
        connection.startup(db_name, base)
        cursor = connection.cursor()
        cursor.execute("create table issues (id integer, issueid integer, date varchar,email varchar, problem varchar)")
        connection.commit()
        connection.close()

    dbcon = gadfly.gadfly(db_name, base)
    return dbcon


def list_issues(issue_id = None):
    global db_name
    dbcon = get_con(db_name)
    curs = dbcon.cursor()
    if not issue_id:
        curs.execute("select id, issueid, date, email, problem " \
                     "from issues order by issueid, id, date")
    else:
        issue = int(issue_id)
        curs.execute("select id, issueid, date, email, problem " \
                     "from issues "  \
                     "where issueid = %s " \
                     "order by issueid, id, date"  % (issue))

    try:
        result = curs.fetchone()
        while result != None:
            yield result
            # Use an exception to catch the error... 
            try:
                result = curs.fetchone()
            except:
                result = None
    except:
        # No results probably
        pass

    dbcon.close()
    return

def list_issue_ids():
    global db_name
    dbcon = get_con(db_name)
    curs = dbcon.cursor() 
    curs.execute("select distinct issueid from issues order by issueid")
    try:
        result = curs.fetchone()
        while result != None:
            yield result
            # Use an exception to catch the error... 
            try:
                result = curs.fetchone()
            except:
                result = None
    except:
        # No results probably
        pass

    dbcon.close()
    return

def add_issue(email, problem):
    global db_name
    dbcon = get_con(db_name)
    cursor = dbcon.cursor()

    id = 0
    issue_id = 0
    timestamp = datetime.datetime.now()
    try:
        cursor.execute("select max(id),max(issueid) from issues")
    except:
        pass
    else:
        result = cursor.fetchone()
        # print >>sys.stderr, result
        id = result[0] + 1
        issue_id = result[1] + 1

    # Now insert with the current id and issue_id
    cursor.execute("insert into issues(id, issueid, date, email, problem) " \
                   " values (%d, %d, '%s', '%s', '%s')" % (id, issue_id, timestamp.isoformat(), email, problem))
    dbcon.commit()
    dbcon.close()
    return issue_id


def add_to_issue(issue_id, email, problem):
    global db_name
    dbcon = get_con(db_name)
    cursor = dbcon.cursor()

    id = 0
    timestamp = datetime.datetime.now()
    try:
        cursor.execute("select max(id) from issues")
    except:
        pass
    else:
        result = cursor.fetchone()
        id = result[0] + 1

    # Now insert with the current id and issue_id
    cursor.execute("insert into issues(id, issueid, date, email, problem) " \
                   "values (%d, %d, '%s', '%s', '%s')" % (id, issue_id, timestamp.isoformat(), email, problem))
    dbcon.commit()
    dbcon.close()
    return issue_id


def dateformat(date_value):
    val = re.sub("([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9:]{8})\\.[0-9]+", "\\1-\\2-\\3 \\4", date_value)
    return val


# Command line interface
if __name__ == "__main__":
    import pdb

    def test():
        add_issue("nferrier@tapsellferrier.co.uk", "clean up this demo")
        for x in list_issues():
            print x

    def test2():
        add_to_issue(0, "nferrier@tapsellferrier.co.uk", "added a date column")
        add_to_issue(0, "nferrier@tapsellferrier.co.uk", "added an add_to_issue method")
        for x in list_issues():
            print x

    # print the issues
    for x in list_issues():
        print x

    #test2()
   
# End
