<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet  version="1.0" 
                 xmlns:http="http://www.tapsellferrier.co.uk/namespace/xslt_http_ns"
                 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="http:request[http:uri and http:method='GET']" priority="-1">
        <xsl:message>generic GET uri matcher matched <xsl:value-of select="http:path"/></xsl:message>
        <http:response>
            <http:file select="uri" />
        </http:response>
    </xsl:template>

    <xsl:template match="http:request[http:uri and not(http:method='GET')]" priority="-1">
        <xsl:message>generic non-GET uri matcher matched <xsl:value-of select="http:path"/></xsl:message>
        <http:response>
            <http:status>405</http:status>
        </http:response>
    </xsl:template>

    <xsl:template match="*[namespace-uri(.) = 'http://www.tapsellferrier.co.uk/namespace/xslt_http_ns']" priority="-1">
        <xsl:message>generic matcher</xsl:message>
    </xsl:template>

</xsl:stylesheet>
