/* Simprun/Expr.h
 *
 * Expression classes
 * 
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 
 *
 */
 

#ifndef __EXPR_H
#define __EXPR_H

#include <cstdlib>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include "sym_tab.h"
#include <map>
#include "scope.h"

//extern map <string, symtab_ent *> sym_table;
extern vector<scope*> active_scope_list;
using namespace std;

class expr_node{
public:
	//class symtab_ent * symp;
	int line_number;
	int sem_value;
	expr_node() : line_number(0), sem_value(0){}
	virtual float eval(vector<string>& data_arr, fstream& eval_out){
		cout <<	"expr_node::eval(fstream& eval_out):Error: Neil wanted to make me pure virtual";
	}
	virtual ~expr_node(){}
	virtual void print(fstream& edit_out){
		edit_out <<	"expr_node::print(fstream& edit_out):Error: Neil wanted to make me pure virtual";
	}
};

class name_expr: public expr_node{
public:
	symtab_ent* s_ent;
	//class symtab_ent *s_ent;
	name_expr(symtab_ent* s): s_ent(s) {} 
#if 0
	name_expr(string& s): expr_node(){
	//assgn_expr(symtab_ent * s_ent, expr_node * e):
		
#if 0
		if(sym_table.find(s)==sym_table.end()){
			cout << s << 
			": not found in symbol table: " 
			<< endl;	
			//s_ent=NULL;
			return;
		}
		s_ent=sym_table[s];
		//cout << "name_expr::name_expr()" << endl;
#endif /* 0 */
		bool found=false;
		int i = active_scope_list.size()-1;
		for(; i>-1; --i){
			if (active_scope_list[i]->sym_tab.find(s)==
				active_scope_list[i]->sym_tab.end() ){
			} else {
				found = true;
				break;
			}
		}
		if(found == false){
			cout << "ID:" << s << ": not found\n";
		} else {
			cout << "ID:" << s << ": found\n";
		}
	}
#endif /* 0 */
	float eval(vector<string>&data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class bin_op: public expr_node{
public:
	expr_node * left_e, * right_e;
	bin_op(expr_node* l, expr_node* r): expr_node(){
		left_e = l; right_e = r;
	}
	~bin_op(){
		delete left_e; delete right_e;
	}
	//void print(fstream& edit_out);
	virtual float eval(vector<string>& data_arr, fstream& eval_out)=0;
	virtual void print(fstream& edit_out)=0;
};

class uni_minus: public expr_node{
public:
	expr_node * operand;
	uni_minus(expr_node * en): operand(en) { }
	float eval(vector<string>& data_arr, fstream& eval_out);
	~uni_minus(){ delete operand; }
	void print(fstream& edit_out);
};

class paren_expr: public expr_node{
public:
	expr_node *operand;
	paren_expr(expr_node *en){ operand = en; }
	float eval(vector<string>& data_arr, fstream& eval_out);
	~paren_expr(){ delete operand; }
	void print(fstream& edit_out);
};

class a_plus: public bin_op{
public:
	a_plus(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	//~a_plus(){}
	void print(fstream& edit_out);
};

class mult: public bin_op{
public:
	mult(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	//~mult(){}
	void print(fstream& edit_out);
};

class a_minus: public bin_op{
public:
	a_minus(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	//~a_minus(){}
	void print(fstream& edit_out);
};

class mr_expr: public expr_node{
public:
	int column_no;
	int mask;
	int single_coded;
	mr_expr(int c_no, int codes) { column_no=c_no; mask=codes; }
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class a_div: public bin_op{
public:
	a_div(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	// I have to take care of div by 0
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class less_eq: public bin_op{
public:
	less_eq(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class greater_eq: public bin_op{
public:
	greater_eq(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class greater_than: public bin_op{
public:
	greater_than(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class is_eq: public bin_op{
public:
	is_eq(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class is_noeq: public bin_op{
public:
	is_noeq(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class number: public expr_node{
public:
	int value;
	number(int v) { value = v; }
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class less_than: public bin_op{
public:
	less_than(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class lor: public bin_op{
public:
	lor(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class land: public bin_op{
public:
	land(expr_node/*&*/ *l, expr_node/*&*/ *r): bin_op(l, r){}
	float eval(vector<string>& data_arr, fstream& eval_out);
	void print(fstream& edit_out);
};

class assgn_expr: public expr_node{
	public:
	struct symtab_ent * symp;	
	struct expr_node * expr;
	assgn_expr(symtab_ent * s_ent, expr_node * e):
		symp(s_ent), expr(e) {
	}

	void  print(fstream& edit_out){
		edit_out << symp->name << '=' ;
		expr->print(edit_out);
		//edit_out << ";\n";
		//<< symp->get_value() << endl;
	}

	float  eval(vector<string>& data_arr, fstream& eval_out){
		//eval_out << symp->name << '=' ;
		//expr->print(eval_out);
		//eval_out << ";\n";
		//<< symp->get_value() << endl;
		symp->set_value(expr->eval(data_arr, eval_out));
		eval_out << "eval::assgn_stmt\n";
		return symp->get_value();
	}

};

#endif /* __EXPR_H */
