/* Simprun/Stmt.C
 *
 * Edit section statement classes 
 * 
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to 

 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 
 *
 */

#include "config.h"
#include "Stmt.h"
#include <list>
#include <algorithm>
#include <functional>

using namespace std;

#if 0
void print_stmt_lst(list<stmt_node*>& stmt_node_list){
#if DEBUG
	cout << "print_stmt_lst" << endl;
#endif /* DEBUG */
	for_each(stmt_node_list.begin(), stmt_node_list.end(),
		mem_fun(&stmt_node::print));

}
#endif /* 0 */
void print_stmt_lst(stmt_node*&  st, fstream& edit_out){
	stmt_node * st_ptr =st;
	/* we have built the chain in reverse order
	 * so we run down the chain and print it out 
	 * backwards
	 */
	//cout << "print_stmt_lst\n\n\n\n";
	//cout << endl;
	//cout << "print_stmt_lst:START" << endl; 
	while(st_ptr->next_stmt) {
		st_ptr=st_ptr->next_stmt;
		//edit_out << "inside while here\n";
	}
	//cout << "reached here\n";
	while(st_ptr){
		st_ptr->print( edit_out);
		st_ptr=st_ptr->prev_stmt;
	}
}

#if 0
void print_expr(class expr_node * e){
	if( e ) { e->print(); }
}
#endif /* 0 */


void eval_stmt_lst(stmt_node*  st, vector<string>& data_arr,  fstream& eval_out){
	stmt_node * st_ptr =st;
	/* we have built the chain in reverse order
	 * so we run down the chain and print it out 
	 * backwards
	 */
	 
	//eval_out << "eval_stmt_lst:START" << endl;
	while(st_ptr->next_stmt) st_ptr=st_ptr->next_stmt;
	while(st_ptr){
		//st_ptr->print( eval_out);
		st_ptr->eval(data_arr, eval_out);
		st_ptr=st_ptr->prev_stmt;
	}
}

extern struct current_rec_info curr_rec_info;
void count_stmt::eval(vector <string>& data_arr, fstream& eval_out){
	//eval_out << "Eval count_stmt\n";
	h_cont->hole_count(data_arr, &curr_rec_info);
}
