/* Simprun/Tab.h
 *
 * Tablulation section header file - classes for constructing and printing
 * tables.
 * 
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */
 

#ifndef __TAB_H
#define __TAB_H
#include "Expr.h"
#include <map>
#include <fstream>
#include <vector>
using namespace std;
int yyparse();

struct table{
	string side;
	string banner;
	expr_node* filter;
	table(string s, string t, expr_node* f=NULL) {
		side=s; banner=t; filter=f;}
};


class basic_ax_stmt	{
	public:
	int type;
	//char * text;
	//struct expr_node * expression;
	basic_ax_stmt * next_ax_stmt;
	basic_ax_stmt * prev_ax_stmt;
	basic_ax_stmt(): next_ax_stmt(NULL), prev_ax_stmt(NULL) {}

	virtual void print(fstream& f){
		f << "basic_ax_stmt::print(): should not be called\n";
	}


	//void print(){  
	//void eval(vector <string>& data_arr, fstream& f){
	//	f << "basic_ax_stmt::eval() should never be called\n";
	//}
	//int count;
};

class basic_print_ax_stmt: public basic_ax_stmt{
	public:
	string text;
	basic_print_ax_stmt(string s): basic_ax_stmt(), text(s){}
	virtual void print(fstream& f){
		f << text << endl ;
	}
};

class ttl_ax_stmt: public basic_print_ax_stmt{
	public:
	ttl_ax_stmt(string s): basic_print_ax_stmt(s) {}
	void print(fstream& f){
		//f << "invoked ttl_ax_stmt::print()\n";
		basic_print_ax_stmt::print(f);
		//f << "Hello,World2\n";
	}
};

class basic_count_ax_stmt: public basic_ax_stmt{
	public:
	string text;
	int count;
	struct expr_node* condn;
	basic_count_ax_stmt(string txt, struct expr_node* c): basic_ax_stmt(),
		text(txt), condn(c), count(0){}
	virtual void eval(vector <string>& data_arr, fstream& f){
		if(condn ){
			if (condn->eval(data_arr, f) ) {
				count ++;
			}
		} else {
			count++;
		}
	}
	virtual void print(fstream& f){
		f << "basic_count_ax_stmt::print(): Should not be called\n";
	}
};

class count_ax_stmt: public basic_count_ax_stmt{
	public:
	count_ax_stmt(string txt, struct expr_node* c): basic_count_ax_stmt(txt,c) {}
	void eval(vector <string>& data_arr, fstream& f){
		if(condn ){
			if (condn->eval(data_arr, f) ) {
				count ++;
			}
		} else {
			count++;
		}
	}
	virtual void print(fstream& f){
		f << "CNT: " << text ;
		if (condn)
			condn->print(f) ;
		f << "\n";
		
	}
};

class tot_ax_stmt: public basic_count_ax_stmt{
	public:
	tot_ax_stmt(string txt, struct expr_node* c): basic_count_ax_stmt(txt,c) {}
	void eval(vector <string>& data_arr, fstream& f){
		f << "tot_ax_stmt::eval()\n";
		if(condn ){
			if (condn->eval(data_arr, f) ) {
				count ++;
			}
		} else {
			count++;
		}
	}
	virtual void print(fstream& f){
		f << "TOT: " << text;
		if(condn)
			condn->print(f);
		f << "\n";
	}
	
};

//struct ax_stmt * new_ax_stmt();

class ax	{
	public:
	//struct ax_stmt * ax_stmt_start;
	basic_ax_stmt * ax_stmt_start;
	vector <basic_count_ax_stmt*> bas_cnt_ax_stmt_list;
	expr_node* filter;
	ax(basic_ax_stmt* ax_s, expr_node* f): ax_stmt_start(ax_s), filter(f) {}
};

//struct ax * new_ax();

//extern struct ax * ax_root;

//void print_report( struct ax * axis);
// void print_report( map<string, ax*>& ax_map);

//void print_cond(struct ax_stmt * ax_stmt_ptr);
int yylex ( void );

void construct_tables(map<string, ax*>& ax_map, vector<table*> & table_list);

typedef map<string, ax*>::const_iterator CMAPITER;

void construct_internal_table(map<string, ax*>& ax_map, vector<table*>& table_list);

struct internal_table{
	vector<basic_count_ax_stmt*> side;
	vector<basic_count_ax_stmt*> banner;
	vector< vector<int> >tbl_counter;
	vector< vector<float> > tbl_perc;
	ax* side_ax, *ban_ax;
	internal_table(CMAPITER &map_iter_s, CMAPITER &map_iter_b, 
			expr_node* f, int i);
	expr_node* filter;
	expr_node* ban_filter;
	expr_node* side_filter;
	int base;
	int index;
};

void compute_table(vector<string>& data_arr);
void print_table(fstream& tab_ );
bool check_count(internal_table* itbl_ptr, mr_expr* mr_ptr, int row, 
		fstream& chk_rpt);
int check_tables (vector<table*>& table_list);
#endif /* __TAB_H */
