/* Simprun/generate_program.c
 *
 * Later this will be the heart of the compiler
 * 
 * Copyright (C) September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 
 *
 */
 

/* Dec: 2003
*Documentation for the algorithm for the main loop
*
*main() {
*	start
*	
*	open data file;
*	do {
*		read a record;
*		for each tabulated axis(){
*			check the axis expr;
*			if( column  satisfies axis expr){
*				increment statement count for that axis
*			}
*		}
*	} ( while there are records to read );
*
* 	all records have been read 
*	fori( each axis ){
*		for (each axis statement){
*			print the axis statement; 
*			print the count;
*		}
*	}
*
*	end
*} */ 

/* the functions in this file are called once the input program has been 
 * parsed
 * */

/* below will be implemented later
 * right now we try to get the interpreter going
 */ 
/*void generate_code(struct ax * axis){
	generate_main_loop_start(axis);
	generate_test_exprs(axis);
	generate_final_section(axis);
}*/

#include "config.h"
#define DEBUG_MAIN_LOOP		0
#define DEBUG_GET_RECORD 	0
#define DEBUG_GET_CRD 0
#define DEBUG_GET_SERIAL 0
#include <fstream>
#include "generate_program.h"
#include "Tab.h"
#include "hole_count.h"
#include "Expr.h"
#include "Stmt.h"

#include <iostream>
#include <set>
#include <functional>
#include <string>
#include <iostream>
#include <vector>
#include <fstream>


/* The below function actually does the data reading for each record
 * for each axis
 */ 
extern struct stmt_node* tree_root;

// after the firs record is read this will be re-set
// required for correctly setting up hole count arrays
int first_record=1;
int new_record=1;
#define MAX_LEN 150

struct current_rec_info curr_rec_info;
//void main_loop(struct ax * ax_root)

void main_loop(map<string, ax*>& ax_map, struct data_file_info& data_file_info,
		char * data_fname){
	// open file
	//fstream file("test.yyy", ios_base::in);
	fstream file(data_fname, ios_base::in);
	if(!file){
		cerr << "Unable to open datafile: " << data_fname << endl;
		exit(1);
	}
	//fstream ofile("chktest.dat", ios_base::out);
	curr_rec_info.prev_ser_no = curr_rec_info.ser_no = 
		curr_rec_info.crd_no = curr_rec_info.prev_crd_no = 0;
	printf("Enter main_loop()\n");

	//struct data_file_info data_file_info;
	//data_file_info.ser_start=1; data_file_info.ser_end=5;
	//data_file_info.crd_start=6; data_file_info.crd_end=7;
	//data_file_info.reclen = 150; data_file_info.max = 19;
	string tmp_hold;
	getline(file, tmp_hold);
	vector<string> line(data_file_info.max+10);
	bool breakout=false;
	int len_crd=data_file_info.crd_end-data_file_info.crd_start+1;
	int len_ser=data_file_info.ser_end-data_file_info.ser_start+1;
	curr_rec_info.rec_cnt = 0;
	while ( !file.eof() ){
		//cout << "Top of outer while()" << endl;
		line[0]=tmp_hold;
		int i=1;
		// setup a set to store the card nos.
		// we need this for repeated cards
		set<long int, less<long int> > card_set;

		curr_rec_info.crd_no=strtol(line[0].substr
			(data_file_info.crd_start-1, len_crd).c_str(), NULL, 10);
		card_set.insert(curr_rec_info.crd_no);
		//cout << "Inserting Crd no: " << curr_rec_info.crd_no  << "size:" << card_set.size() << endl;
			
		curr_rec_info.ser_no=strtol(line[0].substr
			(data_file_info.ser_start-1, len_ser).c_str(), NULL, 10);
		do{
			getline(file, line[i]);
			if (file.eof()){
				breakout=true;
				//printf("got EOF; breaking out\n");
				cout  << endl << "got EOF; breaking out\n";
				break;
			}
			curr_rec_info.prev_crd_no = curr_rec_info.crd_no;
			curr_rec_info.crd_no=strtol(line[i].substr
				(data_file_info.crd_start-1, len_crd).c_str(), 
				NULL, 10);
			curr_rec_info.prev_ser_no=curr_rec_info.ser_no;
			const char * c_ser = line[i].substr 
				(data_file_info.ser_start-1, len_ser).c_str();
			curr_rec_info.ser_no = strtol(c_ser, NULL, 10);
			if ( curr_rec_info.prev_ser_no==curr_rec_info.ser_no ){
				set<long int>::const_iterator found=
					card_set.find(curr_rec_info.crd_no);
				if ( found!=card_set.end() ){
					cout << "Error : repeated card no: "
						<< curr_rec_info.crd_no << 
						"*found: " << *found<< endl;
					cout << "card_set.size(): " <<
						card_set.size() << endl;
					
					breakout = true;
				} else {
					card_set.insert(curr_rec_info.crd_no);
				}
			}
			i++;
		} while (curr_rec_info.prev_ser_no==curr_rec_info.ser_no&&!breakout);

		card_set.clear();
		curr_rec_info.rec_cnt++;
		if (breakout ) { breakout=false; continue; }
		if(curr_rec_info.rec_cnt%80==0){
			cout << "." << endl;		
		} else {
			cout << ".";		
		}
		fstream eval_out("EVAL_OUT", ios_base::out|ios_base::trunc);
		//cout << "before eval_stmt_lst\n";
		eval_stmt_lst(tree_root, line, eval_out);
		//cout << "after eval_stmt_lst\n";
		//compute_test_exprs(ax_map, line, &curr_rec_info);
		compute_table(line);
		// very soon this moves into the grammar
		//hole_count(line, &curr_rec_info, start_col, end_col);
		tmp_hold=line[i-1];
	}
	//printf("Exit main_loop\n");
}

// I think this is an important concept
// For a DP to be able to check the axes on total internally.

// May 1004
// But I'll think about i for some more time and decide whether it should be put in
/// Or Il have to maintain 2 places in code for computing axes etc.
// I'll comment it out of now - hence
#if 0
void compute_test_exprs(map<string, ax*>& ax_map, vector<string> & data_arr, struct current_rec_info * current_rec_info){
	//struct ax * ax_ptr=axis;
	typedef map<string, ax*>::const_iterator CMAPITER;
	CMAPITER m_iter=ax_map.begin();
	fstream eval_out("EVAL_OUT", ios_base::out|ios_base::ate);
	do {
		//if(ax_ptr->filter==NULL || 
		//	ax_ptr->filter->eval(data_arr)){	
		if(m_iter->second->filter==NULL || 
			m_iter->second->filter->eval(data_arr, eval_out)){	
			basic_ax_stmt * ax_stmt_ptr = m_iter->second->ax_stmt_start;
			do{
				expr_node * l_expr = ax_stmt_ptr->expression;
				//int c_crd=l_expr->column/100;
				//int c_col=l_expr->column%100;
				//if( data_arr[l_expr->column]&l_expr->mask)
				if(l_expr->eval(data_arr, eval_out)){
					ax_stmt_ptr->count++;
#if DEBUG_COMPUTE_TEST_COND
					printf("crd_no: %d column_no:%d: count:%d\n",
						c_crd, c_col, ax_stmt_ptr->count);
#endif /* DEBUG_COMPUTE_TEST_COND */
				}
				ax_stmt_ptr=ax_stmt_ptr->next_ax_stmt;
			}while(ax_stmt_ptr);
		}
			
		//ax_ptr=ax_ptr->next_ax;
		m_iter++;
	} while(m_iter!=ax_map.end());
}
#endif /* 0 */

// May 1004
// The below function prints out the counts for the axes
// I'll comment this out also for the moment
// It works on the output generated by the above function
#if 0
void print_report( map<string, ax*>& ax_map){
	fstream output("DRAFT_AXES.RPT", ios_base::out);
	typedef map<string, ax*>::const_iterator CMAPITER;
	CMAPITER m_iter = ax_map.begin();
	//struct ax * ax_ptr=axis;
	//printf("\n\n");
	output << endl << endl;
	do {
		//printf("ax_ptr->ax_name: %s\n", ax_ptr->ax_name);
		//struct ax_stmt * ax_stmt_ptr = ax_ptr->ax_stmt_start;
		output << "ax_name: " << m_iter->first << endl;
		basic_ax_stmt * ax_stmt_ptr = 
			m_iter->second->ax_stmt_start;
		do{
			//printf("ax_stmt_ptr->ax_stmt_name: %s\n", 
			//printf("%s\t\t", ax_stmt_ptr->text);
			output << ax_stmt_ptr->text << "\t\t";
			struct expr_node * l_expr = ax_stmt_ptr->expression;
			//printf("%d\n", ax_stmt_ptr->count);
			output << ax_stmt_ptr->count << endl;
			ax_stmt_ptr=ax_stmt_ptr->next_ax_stmt;
		}while(ax_stmt_ptr);
		//printf("\n\n");
		output << endl << endl;
		//ax_ptr=ax_ptr->next_ax;
		m_iter++;
	} while(m_iter!=ax_map.end());
}
#endif /* 0 */
