/* XtCC/gram.y
 *
 * xtcc grammar
 * Grammar for the input language
 * 
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Reference: Lex and Yacc, O'Reilly
 *            gnu bison documentation pages (info bison)
 *		The C++ Programming Language 3rd edition - Addison Wesley
 *			-Bjarne Stroustrup
 *                 in particular section 6.1.8 "A Note on Style"
 *
 *
 */
 
%{

#include "Stmt.h"
#include "Expr.h"
#include "sym_tab.h"
#include "Tab.h"
#include "hole_count.h"
#include "generate_program.h"
#include <cstdio>
#include <map>
#include <list>
#include <string>

	extern int yylineno;
	extern char* yytext;
	using namespace std;

	//extern map <string, symtab_ent *> sym_table;
	int yylex(void);
	int yyerror(const char * msg);
	extern struct stmt_node * tree_root;

	extern map <string, ax*> ax_map;
	extern vector<table*>	table_list;

	extern vector<count_stmt*> count_list_stack;
	extern struct data_file_info data_file_info;
	extern count_stmt* hc_check_ptr;
	int no_err;

	// New for scopes
	vector <scope*> active_scope_list;
	//scope* active_scope = new scope();
	scope* active_scope ;
	map<string, symtab_ent*>::iterator find_in_symtab(string id);
%}

%union {
	class basic_ax_stmt * basic_ax_stmt;
	struct ax * ax;
	struct expr_node * e_node;
	char * name;
	char * text;
	int mask;
	int column_no;
	double dval;
	struct table * tbl;
	struct stmt_node *stmt;
	struct cmpd_stmt *c_stmt;
};

%type <tbl> tab_list
%type <tbl> tab_defn
%type <ax>	ax_list
%type <ax>	ax_defn
%type <basic_ax_stmt> ax_stmt_list
%type <basic_ax_stmt> ax_stmt
%type <stmt> statement
%type <stmt> statement_list
%type <stmt> decl_statement
%type <stmt> decl_list
%type <stmt> for_stmt
/*%type <stmt> emit_stmt*/
%type <e_node>	expression
%type <e_node>	mr_expr
%type <c_stmt> open_curly
%type <c_stmt> compound_stmt

%token EDSTART
%token EDEND
%token INT
%token FLOAT
%token IF
%token ELSE
%token TABSTART
%token TAB
%token	TOT AX ';' CNT '{' '}' TTL
%token <name> NAME 
%token COND_START
%token <text> TEXT 
%token ERROR
%token <column_no> SCOLUMN
%token <mask> CODELIST
%token COL_FLOAT
%token COL_INT
%token <column_no>	NUMBER
%token <dval>	REAL
%token COUNT USETHIS
%token FOR
%token EMIT
%token DELETE
%token AXSTART

%token STRUCT  READ  CARD_DATA  CRD   NUMBER  NUMBER    SERIAL   NUMBER  NUMBER   RECLEN  NUM FLAT_DATA	PREAMBLE MAX
// Below sets the priorities for the expression grammar
%right '='
%left LOGOR
%left LOGAND
%left ISEQ NOEQ 
%left LEQ GEQ '<' '>' 
%left '-' '+'
%left '*' '/'
%nonassoc UMINUS
%token '('
%token ')'

%%

start: PREAMBLE '{' preamble '}'	{
#if DEBUG_GRAM
		cout << "got preamble\n";
#endif /* DEBUG_GRAM */
		return 0;
	}
	| AXSTART '{' ax_list 	'}'	{
#if DEBUG_GRAM
		cout << "got axes\n";
#endif /* DEBUG_GRAM */
		return 0;
	}
	| TABSTART '{' tab_list '}' {
#if DEBUG_GRAM
		printf("got TABSTART\n");
#endif /* DEBUG_GRAM */
		return 0;
	}
	| EDSTART 	ed_list  EDEND {
#if DEBUG_GRAM
		printf("got ed_list\n");
#endif /* DEBUG_GRAM */
		return 0;
	}
	;
	/*
	| error '}'	{
		cout << "error on line" << yylineno <<  
			"Skipping to next }\n";
	}
	*/

preamble:	STRUCT ';' READ '=' FLAT_DATA ';' SERIAL '=' 
		'(' NUMBER ',' NUMBER ')' ';' RECLEN '=' NUMBER ';'	{
			
		data_file_info.ser_start=$10; data_file_info.ser_end=$12;
		data_file_info.crd_start=0; data_file_info.crd_end=0;
		data_file_info.reclen = $17; data_file_info.max = 0;
		//cout << 
		//	";ser_start="<< data_file_info.ser_start <<
		//	";ser_end=" << data_file_info.ser_end << 
		//	";crd_start="<< data_file_info.crd_start <<
		//	";crd_end=" << data_file_info.crd_end << 
		//	";reclen="   << data_file_info.reclen <<
		//	";max ="    << data_file_info.max <<
		//	endl;
	}
	|	STRUCT ';' READ '=' CARD_DATA ';' 
			SERIAL '=' '(' NUMBER ',' NUMBER ')' ';' 
			CRD '=' '(' NUMBER ',' NUMBER ')' ';' 
			RECLEN '=' NUMBER ';' 
			MAX '=' NUMBER ';' {

		data_file_info.ser_start=$10; data_file_info.ser_end=$12;
		data_file_info.crd_start=$18; data_file_info.crd_end=$20;
		data_file_info.reclen = $25; data_file_info.max = $29;
		//cout << "ser_start" << 
		//	";ser_start="<< 	data_file_info.ser_start<<
		//	";ser_end=" << data_file_info.ser_end << 
		//	";crd_start="<< 	data_file_info.crd_start<<
		//	";crd_end=" << data_file_info.crd_end << 
		//	";reclen="<< 	data_file_info.reclen  	<<
		//	";max =" << data_file_info.max <<
		//	endl;
	}

ed_list: func_defn {
		cout << "func_defn\n";
	}
	| ed_list func_defn {
		cout << "chaining ed_list\n";
	}
	;

/*edlist: '{' statement_list '}'*/
	/*
ed_list: compound_stmt
	{
	tree_root = $1;
	}
	*/
	/*
	| declarator	id '(' 	
	*/

/*
func_defn:	declarator NAME '(' decl_list ')' '{' statement_list '}' {
*/
func_defn:	declarator NAME '(' decl_list ')' compound_stmt {
		tree_root = $6;
		//tree_root = $7;
		cout << "tree_root: " << tree_root << endl;
		//cout << "Should not appear for the moment\n";
	}
	;

statement_list: statement  { 
		//printf(" got a statement\n"); 
		// later on reverse the chain
		$$ = $1;
		//stmt_node_list.push_back($1);
	}
	| statement_list statement {
		$2->next_stmt = $1;
		$1->prev_stmt = $2;
		$$ = $2;
		//stmt_node_list.push_back($2);
	}
	;

/*
	      NAME '=' expression ';' {
	//I have to correct this code
		//$1->value = $3; printf("%g\n", $3); 
		map<string,symtab_ent*>::iterator sym_it = sym_table.
				find(string($1));
		if(sym_it!=sym_table.end()){
			$$ = new assgn_stmt( sym_it->second, $3);
		} else	{
			// This below is an error 
			// semantic error and
			// I should report it
			$$ = new assgn_stmt( NULL, $3);
			cout << string($1) << "not found in sym_table"
				<< endl;
		}
	}
	*/

compound_stmt: open_curly statement_list '}'	{ 
		//cout << "popping scope: " <<
		//	active_scope_list[active_scope_list.size()-1] << endl;
		active_scope_list.pop_back();
		int tmp=active_scope_list.size()-1;
		if(tmp==-1) { 
			active_scope = NULL;
			cout << "Error: active_scope = NULL: should not\
				happen\n";
			no_err++;
		} 
		else { active_scope = active_scope_list[tmp]; }
		$1->c_stmt = $2;
		$$=$1;
	}
	;

open_curly:	'{' {
		$$ = new cmpd_stmt();
		//cout << "open_curly: cmpd_stmt: " << $$ << endl;
		//cout << "pushed active_scope: " << active_scope << endl;
		//active_scope_list.push_back(active_scope);
		active_scope_list.push_back($$->sc);
		active_scope = $$->sc;
		//cout << "active_scope: " << active_scope << endl;
	}
	;

statement: expression ';' {
		$$ = new expr_stmt($1);
	}
	| IF '(' expression ')'  statement 	{
		$$ = new if_stmt($3, $5, NULL);
	}
	| IF '(' expression ')'  statement ELSE  statement 	{
		$$ = new if_stmt($3,$5,$7);
		//cout << "if else" << endl;
	}
	|  	compound_stmt {
		$$ = $1;
	}
	|	decl_statement	{
		$$=$1;
	}
	|	COUNT '(' NUMBER ')' ';' /* parametrizable TEXT */ {
		// one fine day I will change NUMBER to expression
		// so that you can take counts in a loop
		// with a variable i
		// and I want parametrizable text 
	}
	|	COUNT '(' NUMBER ',' NUMBER ')' ';'{
		count_stmt * c_ptr = new count_stmt($3, $5, "");
		$$ = c_ptr;
		count_list_stack.push_back(c_ptr);
#if 0
		count_stmt * cnt_stmt_ptr = dynamic_cast<count_stmt*> ($$);
		if(cnt_stmt_ptr){
			count_list_stack.push_back(cnt_stmt_ptr);
		} else {
			cerr << "dynamic cast failed... exiting\n";
			exit(1);
		}
#endif /* 0 */
	}
	|	COUNT '(' NUMBER ',' NUMBER ')' USETHIS ';'{
		// This is the statement which will be used for
		// checking the TAbles
		count_stmt * c_ptr = new count_stmt($3, $5, "");
		$$ = c_ptr;
		count_list_stack.push_back(c_ptr);
		hc_check_ptr = c_ptr;
	}
	|	for_stmt { $$=$1;
	}
	|	EMIT SCOLUMN CODELIST ';'{
		$$ = new emit_stmt ($2,$3);
	}
	|	DELETE SCOLUMN CODELIST ';'{
		$$ = new delete_stmt ($2,$3);
	}
	| 	error ';'	{
		cout << "error on line:" << yylineno <<  
			" skipping to next ';'\n";
	}
	;

for_stmt:	FOR '(' expression ';' expression ';' expression ')'
			statement {
		$$ = new for_stmt ($3, $5, $7, $9); 
	}
	| error '}'	{
		cout << "error on line:" << yylineno <<  
			"skipping to next '}'\n";
	}
	/*
	| error ';' {
		cout << "error on line:" << yylineno <<  
			"skipping to next ';'\n";
	}
	*/
		//CONTINUE FROM HERE	
	;

declarator:	INT
	| FLOAT
	;

decl_list: func_decl_param {}
	|	decl_list ','  func_decl_param { }
	;

func_decl_param:	INT NAME	
	|	FLOAT NAME
	;


decl_statement: INT NAME ';'	{
#if DEBUG_GRAM
	cout << "int decl:start\n";
#endif /* DEBUG_GRAM */
	//active_scope->add($1, $2);	
#if 1
	if ( active_scope->sym_tab.find($2) == active_scope->sym_tab.end() ){
#if DEBUG_GRAM
		cout << "int decl:start\n";
#endif /* DEBUG_GRAM */
		struct symtab_ent* s_ent=new struct symtab_ent_int;
		s_ent->name = $2;
		string s($2);
		$$=new int_decl(s_ent);
#if DEBUG_GRAM
		cout << "before insertion\n";
#endif /* DEBUG_GRAM */
		active_scope->sym_tab[s] = s_ent;
#if DEBUG_GRAM
		cout << "after insertion\n";
#endif /* DEBUG_GRAM */
		$$->type = 'D';
	} else {
		cout << " INT NAME failed\n";
		no_err++;
	}
#if DEBUG_GRAM
	cout << "got an int defn\n";
#endif /* DEBUG_GRAM */

#endif /* 0 */
}
	|	FLOAT NAME ';'	{
		if (active_scope->sym_tab.find($2) == active_scope->sym_tab.end() ){
			struct symtab_ent* s_ent=new struct symtab_ent_float;
			s_ent->name = $2;
			string s($2);
			$$=new float_decl(s_ent);
			active_scope->sym_tab[s] = s_ent;
			$$->type = 'F';
		} else {
			cout << " FLOAT NAME failed\n";
			no_err++;
		}
#if DEBUG_GRAM
		cout << "got an float defn\n";
#endif /* DEBUG_GRAM */
	}
	;

tab_list: tab_defn	{ 
#ifdef DEBUG_GRAM
	printf("got table defn\n"); 
#endif
	}
	| tab_list tab_defn { 
#ifdef DEBUG_GRAM
		printf("recursive tab_defn\n"); 
#endif
	}
	;

tab_defn:
	TAB NAME NAME';'	{
		//printf("got table defn: no filter\n");
		$$=new table($2,$3);
		// default value for constructor tbl_ptr->filter=NULL;
		table_list.push_back($$);
		
	}
	| TAB NAME NAME';'COND_START expression';'{
		//printf("got table defn: with filter\n");
		$$=new table($2,$3,$6);
		table_list.push_back($$);
	}
	| error ';' {
		cout << "Error in tab section line: " <<
			yylineno << endl;
	}
	;

ax_list:	ax_defn	{
		//$$ = $1;
	}	
	|	ax_list ax_defn	{
		//$2->next_ax = $1;
		//$1->prev_ax = $2;
		//$$ = $2;
	}
	;

ax_defn:	AX NAME ';' ax_stmt_list {
		$$ = new ax($4, NULL);
		//$$->ax_stmt_start = $4;
		//$$->ax_name = $2;
		ax_map[$2]=$$;
#ifdef DEBUG_GRAM
		printf("NAME: $2: %s\n", $2);
#endif
	}
	|	AX NAME ';'COND_START expression ';' ax_stmt_list {
		$$ = new ax($7, $5);
		//$$->filter = $5;
		//$$->ax_stmt_start = $7;
		//$$->ax_name = $2;
		ax_map[$2]=$$;
#ifdef DEBUG_GRAM
		printf("NAME: $2: %s\n", $2);
#endif
		//printf("\ngot an axis: %s\n", $$->ax_name);
	}
	| error ';'	{
		cout << "Error in axis section line: " <<
			yylineno << endl;
	}
	;


ax_stmt_list: 	
	ax_stmt	{
		$$ = $1;
	}
	|	ax_stmt_list ax_stmt	{
		$2->next_ax_stmt = $1;
		$1->prev_ax_stmt = $2;
		$$ = $2;
	}
	;


ax_stmt:	TOT ';' TEXT ';' {
		$$ = new tot_ax_stmt ($3, NULL);
		if ($$ == NULL){
			cout << "Failed to allocate memory\n";
			exit(1);
		}
	}
	|
	TOT ';' TEXT ';' COND_START expression ';'	{
		/*
		$$=new_ax_stmt();
		$$->type = 'T';
		$$->text = $3;
		$$->expression = $6;
		*/
		$$ = new tot_ax_stmt ($3, $6);
		if ($$ == NULL){
			cout << "Failed to allocate memory\n";
			exit(1);
		}
	}
	|	CNT ';'	TEXT ';' COND_START expression ';' 	{
		/*
		$$=new_ax_stmt();
		$$->type = 'C';
		$$->text = $3;
		$$->expression = $6;
		*/
		$$ = new count_ax_stmt ($3, $6);
		if ($$ == NULL){
			cout << "Failed to allocate memory\n";
			exit(1);
		}
	}
	| 	TTL ';' TEXT ';'	{
		$$ = new ttl_ax_stmt ($3);
	}
	;

/*
cond:	COND_START expression {
	$$=new_cond();
	$$->column = $2;
	$$->mask = $3;
}
*/
// My next task is to update the grammar to
// use C++ defns in expr.h to do the expr evaluation

	// The priorities are wrong - I have to re-arrange the order of the defns
expression: expression '+' expression {
		$$ = new a_plus($1, $3);
	}
	|	expression '-' expression {
		$$ = new a_minus($1, $3);
	}
	|	expression '*' expression { 
		$$ = new mult($1, $3);
	}
	|	expression '/' expression {
			$$ = new a_div($1, $3);
	}
	|	'-' expression %prec UMINUS {
			$$ = new uni_minus($2);
	}
	| 	'(' expression ')'	{ 
		$$ = new paren_expr($2);
	}
	|	expression '<' expression {
			$$ = new less_than($1, $3);
	}
	|	expression '>' expression {
			$$ = new greater_than($1, $3);
	}
	|	expression LEQ expression {
			$$ = new less_eq($1, $3);
	}
	|	expression GEQ expression {
			$$ = new greater_eq($1, $3);
	}
	|	expression ISEQ expression {
			$$ = new is_eq($1, $3);
	}
	| expression NOEQ expression {
			$$ = new is_noeq($1, $3);
	}	
	| expression LOGAND expression {
#ifdef DEBUG_GRAM
			printf("got a LOGAND expression\n");
#endif
			$$ = new land($1, $3);
	}
	| expression LOGOR expression {
			$$ = new lor($1, $3);
	}	
	|	NUMBER	{
			$$ = new number($1);
	}

	|	NAME	{
		//map<string,symtab_ent*>::iterator sym_it = sym_table.
		//		find(string($1));
#if 0
		if (sym_table.find($1) == sym_table.end() ){
			printf("line %d, symbol %s was not declared\n",
			yylineno, $1);
			//return 1;
			no_err++;
		}
#endif /* 0 */
		string s($1);
		map<string,symtab_ent*>::iterator sym_it = 
			find_in_symtab(s);
		if ( sym_it!=active_scope->sym_tab.end() ) {
			$$ = new name_expr( sym_it->second);
		} else {
			printf("line %d, symbol %s was not declared\n",
				yylineno, $1);
			no_err++;
			$$ = new name_expr( NULL);
		}
		//string s($1);
		//$$ = new name_expr(s);
	}
	|	mr_expr
	|	NAME '=' expression	{
		
		//$$ = new assgn_expr($1, $3);
	//I have to correct this code
		//$1->value = $3; printf("%g\n", $3); 
#if 0
		map<string,symtab_ent*>::iterator sym_it = sym_table.
				find(string($1));
		if(sym_it!=sym_table.end()){
			$$ = new assgn_expr( sym_it->second, $3);
		} else	{
			// This below is an error 
			// semantic error and
			// I should report it
			$$ = new assgn_expr( NULL, $3);
			cout << string($1) << " on line: " << yylineno
				<< " not found in sym_table"
				<< endl;
			no_err++;
		}
#endif /* 0 */
		map<string,symtab_ent*>::iterator sym_it = 
			find_in_symtab($1);

		if ( sym_it!=active_scope->sym_tab.end() )  {
			$$ = new assgn_expr( sym_it->second, $3);
		} else {
			$$ = new assgn_expr( NULL, $3);
			cout << string($1) << " on line: " << yylineno
				<< " not found in symbol table"
				<< endl;
			no_err++;
		}
	}
	;

mr_expr:	SCOLUMN	
	{
		$$ = new mr_expr($1, 0xFF);
	}
	|	SCOLUMN CODELIST {
		$$ = new mr_expr($1,$2);
	}
	/*
	|	COL_INT '[' NUMBER ',' NUMBER ']' {
		$$ = new_expr();
		$$->column_no = $3;
		$$->column_no_2 = $5;
		$$->mr_type = 2;
		$$->type = 'M';
	}
	*/
	;

%%


int yyerror(const char * msg){
	no_err++;
	return printf("%d: %s at '%s'\n", yylineno, msg, yytext);
}

map<string, symtab_ent*>::iterator find_in_symtab(string id){
	bool found=false;
	int i=active_scope_list.size()-1;
#if DEBUG_GRAM
	cout << "START: find_in_symtab: i=" << i <<endl;
#endif /* DEBUG_GRAM */

	map<string,symtab_ent*>::iterator sym_it ; 
	for(;i>-1;--i){
		sym_it = active_scope_list[i]->sym_tab.find(id);
		if (sym_it == active_scope_list[i]->sym_tab.end() ){
		} else {
			found = true;
#if DEBUG_GRAM
			cout << "found" << endl;
#endif /* DEBUG_GRAM */
			break;
		}
	}
	if(found==false){
		cout << "ID:" << id <<
			": not found in any scope\n";
		int j=active_scope_list.size()-1;
		map<string,symtab_ent*>::iterator it;
		for(; j>-1; --j){
			cout <<"searching in: " << 
				active_scope_list[j];
			cout << "j=" << j << endl;
			for(it=active_scope_list[j]->sym_tab.begin();
				it!=active_scope_list[j]->sym_tab.end();
				++it){
				cout << it->first << ",";
			}
		}
		return active_scope->sym_tab.end();
	} else {
#if DEBUG_GRAM
		cout << "ID:" << id <<
			": found at scope level:" <<
			i << endl;
#endif /* DEBUG_GRAM */
		return sym_it;
	}
}
