/* XtCC/hole_count.C
 *
 * Holecount generator
 *
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */
#include "config.h"
#include <cstdio>
#include <iostream>
#include "generate_program.h"
#include "Tab.h"
#include "hole_count.h"
struct hole_count_container * hc_cont=NULL;
extern int first_record;
#define DEBUG_HOLE_COUNT 0


void hole_count_container::hole_count(vector<string> & data_arr, struct current_rec_info* curr_rec_info ){
	//struct hole_count_container * hc_cont_ptr = hc_cont;
#if DEBUG_HOLE_COUNT
	printf("Enter hole_count(): first_record:%d: start_col:%d, end_col:%d\n"
			, first_record, start_col, end_col);
#endif
	//: dont think its needed if(first_record){
	// also I never set first_record to false 
	// can you beat that?
	//setup_hole_count_arrays(start_col, end_col);
	// gets setup by the constructor
	//}
	do_hole_count(data_arr, curr_rec_info);
#if DEBUG_HOLE_COUNT
	printf("Exit hole_count():\n");
#endif
}
#define NUM_PUNCHES 8
#define DEN_COUNT 	10
void hole_count_container::new_count_container(){
	//struct hole_count_container * hc_ptr = (struct hole_count_container *)
	//	malloc(sizeof(struct hole_count_container));
	count_arr = (int*) calloc( (end_col-start_col+1)*(NUM_PUNCHES+DEN_COUNT), sizeof(int));
	if(!count_arr){
		printf("failed to allocate a holecount array:exiting!!!!\n");
		exit(1);
	}
}

void hole_count_container::setup_hole_count_arrays(/*int start_col, int end_col*/){
	//struct hole_count_container * hc_cont_ptr = hc_cont;
#if DEBUG_HOLE_COUNT_SETUP
	static int called=0;
	printf("Enter setup_hole_count_arrays(): called: %d\n", ++called);
#endif /* DEBUG_HOLE_COUNT_SETUP */
	new_count_container(/*start_col, end_col*/);
#if DEBUG_HOLE_COUNT_SETUP
	printf("Exit setup_hole_count_arrays():\n");
#endif /* DEBUG_HOLE_COUNT_SETUP */
}
// this function can only be called for single punch count statement
int hole_count_container::get_count(int col, int punch){
	if ( col < start_col || col > end_col){
		return -1;
	} 
	return count_arr[(col-start_col)*
		(NUM_PUNCHES+DEN_COUNT)+punch];
}

void hole_count_container::do_hole_count(vector<string>& data_arr, 
		struct current_rec_info * curr_rec_info){
#if DEBUG_DO_HOLE_COUNT
	static int invoked=0;
	int n_counts =( end_col - start_col + 1)* 
				(NUM_PUNCHES+DEN_COUNT);
#endif /* DEBUG_DO_HOLE_COUNT */
	total++;
	int i, j;
#if DEBUG_DO_HOLE_COUNT
	printf("Enter do_hole_count(): start_col:%d, end_col:%d\n", 
			start_col, end_col);
#endif /* DEBUG_DO_HOLE_COUNT */
	for (i=start_col; i<end_col; i++){
		int p_count=0;
		for(j=0, p_count=0; j<NUM_PUNCHES; j++){
			if( data_arr[i/100][i%100]&(1<<j) ){
				p_count++;
				//printf("increment count: %d: punch:%d",
				//	i, j);
				count_arr[(i-start_col)*
					(NUM_PUNCHES+DEN_COUNT)+j]++;
				//printf("index:%d count:%d\n", 
				//	(i-start_col)* NUM_PUNCHES+j,
				//hc_cont_ptr->count_arr[(i-start_col)*
				//	NUM_PUNCHES+j]);
			}
		}
		count_arr[(i-start_col)*
			(NUM_PUNCHES+DEN_COUNT)+NUM_PUNCHES+p_count]++;
	}
#if DEBUG_DO_HOLE_COUNT
	printf("invoked=%d\n", ++invoked);
	printf("Exit do_hole_count()\n");
#endif /* DEBUG_DO_HOLE_COUNT */
}
#include <cstdlib>
#include <fstream>
void hole_count_container::print_hole_count(fstream& hct_){
	//fstream hct_("hct_", ios_base::out);
	int i=0, j=0;
	if (!hct_){
		cerr << "error opening hct_ for printing holecout" <<endl;
		exit(1);
	}
	print_hcount_header(hct_);
	
	for(i=start_col; i<end_col; i++){
		//printf("%-6d|", i);
		hct_.width(8);
		hct_ << i << "|";
		for(j=0; j<NUM_PUNCHES+DEN_COUNT; j++){
			//printf("%-6d", hc_cont_ptr->count_arr
			//		[(i-hc_cont_ptr->start_col)*NUM_PUNCHES+j]);
			if(j==NUM_PUNCHES){
				hct_.width(8);
				hct_<< "|";
				int blanks=count_arr
				[(i-start_col)*
				(NUM_PUNCHES+DEN_COUNT)+NUM_PUNCHES];
				int any = count_arr
				[(i+1-start_col)*
				(NUM_PUNCHES+DEN_COUNT)-1];
				if (any+blanks!=380){
					hct_ << "P";
				}
			}
			hct_.width(8);
			hct_ << count_arr
				[(i-start_col)*
				(NUM_PUNCHES+DEN_COUNT)+j];
				
		}
		//printf("\n");
		hct_ << endl;
	}
}

void hole_count_container::print_hcount_header(fstream& hct_){
#define LINE_LENGTH	80
	int i=0;
	hct_ << "Total = " << total << endl;
	for(int j=0; j<NUM_PUNCHES; j++){
		hct_ << "P " << j << "\t" << (1<<j) << " ";
	}
	hct_ << endl;
	hct_.width(8);
	//printf("\nCol   |");
	hct_ << "\nCol  |";
	for(i=0; i<NUM_PUNCHES; i++){
		//printf("%-6d", i); 
		hct_.width(8);
		hct_ << i;
	}
	hct_.width(8);
	hct_ << "|";
	hct_.width(8);
	hct_ << "Blanks";
	for(i=NUM_PUNCHES+1; i<NUM_PUNCHES+DEN_COUNT-1; i++){
		hct_.width(8);
		hct_ << "Den" << i-NUM_PUNCHES;
	}
	//printf("\n");
	hct_ <<  endl;
	for(i=0; i<80; i++){
		//printf("-");
		hct_ << "-" ;
	}
	//printf("\n");
	hct_ << endl;
}


void hole_count_container::do_hole_count_summary(){
	for(int i=start_col; i<end_col; i++){
		for(int j=NUM_PUNCHES+1; j<NUM_PUNCHES+DEN_COUNT-1; j++){
			count_arr
				[(i+1-start_col)*
				(NUM_PUNCHES+DEN_COUNT)-1]+=
			count_arr
				[(i-start_col)*
				(NUM_PUNCHES+DEN_COUNT)+j];
		}
	}
}
