/* XtCC/hole_count.h
 *
 * Hole Count Supporting classes defns
 *
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */
#ifndef __HOLE_COUNT_H
#define __HOLE_COUNT_H
#include "Tab.h"
#include <vector>
#include <string>

using namespace std;
struct hole_count_container {
	int total;
	int* count_arr;
	int start_col, end_col;
	hole_count_container(int sc, int ec): start_col(sc), end_col(ec){
		setup_hole_count_arrays();
	}
	void setup_hole_count_arrays(/*int start_col, int end_col*/);
	void new_count_container();
	void do_hole_count(vector<string>& data_arr, 
			struct current_rec_info * curr_rec_info);
	void hole_count(vector<string>& data_arr, 
		struct current_rec_info* curr_rec_info);
	void print_hcount_header(fstream &hct_);
	void print_hole_count(fstream& hct_);
	void do_hole_count_summary();
	int get_count(int col, int punch);
};
#endif 
