/* Simprun/lex.l
 *
 * lexer for the grammar
 *
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Reference: lex and yacc O'Reilly
 * 		flex man page
 *
 */
 
%{
//#include <cstdio>
#include "Tab.h"
#include <cstdlib>

#include "gram.h"
//#include "y.tab.h"
//#include "tgram.tab.h"
#include <math.h>
#include <cstring>
	int yylineno=1;
#include <iostream>
	using namespace std;
	

%}
	
%%

preamble {
	return PREAMBLE;
}

struct {
	return STRUCT;
}

read {
	return READ;
}

flat_data {
	return FLAT_DATA;
}

card_data {
	return CARD_DATA;
}

reclen	{
	return RECLEN;
}

crd	{
	return CRD;
}

serial {
	return SERIAL;
}
	
max	{
	return MAX;
}

	/*
	%{
		extern int first_tok;
		if(first_tok){
			int hold_tok=first_tok;
			first_tok=0;
			printf("returned first_tok\n");
			return hold_tok;
		}
	%}
	*/
edstart	{
#if DEBUG_LEX
	printf("returning EDSTART\n");
#endif /* DEBUG_LEX */
	return EDSTART;
}

edend	{
	//cout << "returning EDEND\n";
	return EDEND;
}
	
axstart {
	return AXSTART;
}

int	{
	//printf("returning INT\n");
	return INT;
}

float	{
	//printf("returning FLOAT\n");
	return FLOAT;
}

if	{
		return IF;
	}

else 	{
		return ELSE;
	}

tabstart	{
	return TABSTART;
}

tab	{
	return TAB;
}
	

\n	{ yylineno ++; }

,	{
	return ',';
}

=	{
	return '=';
}

"<"	{
	return '<';
}

">"	{
	return '>';
}
	
"+"	{	
	return '+';
}

-	{
	return '-';
}

"*"	{
	return '*';
}

"/"	{
	return '/';
}
	

"&&" {
	return LOGAND;
}

"||"	{
	return LOGOR;
}

"!="	{
	return NOEQ;
}

"==" 	{
	return ISEQ;
}

"<="	{
	return LEQ;
}

">=" 	{
	return GEQ;
}

")"	{
	return ')';
}

"("	{
	return '(';
}

"{"	{
	return '{';
}

"}"	{
	return '}';
}


[ \t]	;	/* ign whitespace */

;	{
	return ';';
}

ax	{
	//printf("\nreturned AX\n");
	return AX;
}

tot 	{
	//printf("lex: tot\n");
	return TOT;
}

cnt	{
	return CNT;
}

ttl	{
	return TTL;
}

\".*\"	{
	//printf("lex: TEXT: %s\n", yytext);
	yylval.text = (char*) strdup(yytext);
	return TEXT;
}

c=	{
	//printf("Got COND_START\n");
	return COND_START;
}

c[0-9]+	{
	yylval.column_no = atoi(yytext+1);
	return SCOLUMN;
}

count {
	return COUNT;
}

for	{
	return FOR;
}
	

usethis	{
	return USETHIS;
}

ci	{
	return COL_INT;
}

cf	{
	return COL_FLOAT;
}

emit	{
	return EMIT;
}

delete	{
	return DELETE;
}

[A-Za-z][A-Za-z0-9_]*	{
	//printf("returning name: %s\n", yytext);
	yylval.name = (char * ) strdup(yytext);
	return NAME;
}

'[1-8]+'        {
	int i; int tmp=0;
	for(i = 1; i < strlen(yytext)-1; i++){
		//printf("%d=%c,", i, yytext[i]);
		tmp |= (1<<(yytext[i]-'0'-1));
	}
	//printf("\n");
	if (yyleng==3){
		// Its single coded
		tmp|= 1<<31;
	}
	yylval.mask = tmp;
	//cout << "mask: " << tmp << endl;
	//printf("got a code_list: %s, tmp=%d\n", yytext, tmp);
	//cout << "got a code_list: line_number:" << yylineno << ":"
	//	<< yytext << ":tmp="  << tmp << endl;
	return CODELIST;
}


(([0-9]*\.[0-9]+)([eE][-+]?[0-9]+)?)	{
	yylval.dval = atof(yytext);
	//printf("returned %g\n", yylval.dval);
	return REAL;
	}

[0-9]+	{
	yylval.column_no=atoi(yytext);
	return NUMBER;
}

.	{
printf("unrecog char: %c on line %d\n", yytext[0], yylineno);
return ERROR;
}



%% 

/*
<<EOF>>	{
	return EOF;
}
*/

#if 0
int main (){
	int rval;
	for (;rval!=EOF ; ){
		rval=yylex();
	}
}
#endif /* 0 */

void open_program_file(char * const fname){
#if 0
	if( incl_stk_ptr >= MAX_INCL_DEPTH ){
		printf("includes nested too deep\n");
		exit(1);
	}
	include_stack[incl_stk_ptr++]=YY_CURRENT_BUFFER;
#endif /* 0 */
	yyin=fopen(fname, "r");
	if(!yyin){
		printf("failed to open include file: %s\n", fname);
	}
	yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE) );
}
