/* XtCC/main.C
 *
 * The main function and supporting routines
 * I really haven't planned what goes in here and things
 * are quite haphazard
 *
 * Copyright (C) 2003, September 2004. Neil Xavier D'Souza
 * Residential address as of date above:
 * 502, Premier Park,
 * 1st Tank Lane,
 * Orlem, Malad(W), Mumbai,
 * India.
 * PIN: 400064.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */
//#include "config.h"
#include "config.h"
#include <iostream>
#include <string>
#include <map>
//#include "stmt.h"
#include "Stmt.h"
#include "Tab.h"
#include "hole_count.h"
#include "generate_program.h"
#include <cstdlib>
#include <cstring>
#include <list>
#include <fstream>

using namespace std;
#define MAX_FILENAME	1024
extern void open_program_file(char * const fname);
extern int no_err;
//list <struct stmt_node*> stmt_node_list;
struct data_file_info data_file_info;
struct stmt_node* tree_root;
map <string, ax*> ax_map;
vector<table*>	table_list;
#include "sym_tab.h"
//map <string, symtab_ent *> sym_table;

int yyparse(void);
int yyerror(const char * msg);
//void print_ax_defn(struct ax * ax_root);
void print_ax_map(map<string, ax*>& ax_map);
void print_ax_stmt(struct basic_ax_stmt * axis_stmt, fstream& axmap);


//vector <stmt_node*>  count_list_stack;
vector <count_stmt*>  count_list_stack;
#include "scope.h"
extern vector<scope*> active_scope_list;
extern scope* active_scope;


int main(int argc, char** argv){
	//tree_root=NULL;
	//first_tok = TABSTART;
	char data_fname[MAX_FILENAME];
	if(argc != 3) {
		cout << "\nUsage: xtcc <prog_name> <data_file>" << endl;
		exit( 1);
	} else {
		char fname[MAX_FILENAME];
		strcpy(fname, argv[1]);
		open_program_file(fname);
		strcpy(data_fname, argv[2]);
	}
	active_scope = new scope();
	active_scope_list.push_back(active_scope);
	if(yyparse()){
		cout << " parsing preamble failed\n";
		if( no_err ){
			cout << no_err << " errors detected\n";
		}
		no_err=0;
		exit(1);
	}
	if(yyparse()){
		cout << " parsing edit failed\n";
		if( no_err ){
			cout << no_err << " errors detected\n";
		}
		exit(1);
	} 
#if DEBUG_EDIT_SECTION
	cout << "got edit section\n";
#endif /* DEBUG_EDIT_SECTION */
	if( yyparse() ){
		cout << " parsing edit failed\n";
		if( no_err ){
			cout << no_err << " errors detected\n";
		}
		exit(1);
	}
#if DEBUG_TABLE_DEFN
	cout << "got table section\n";
	for(int i=0; i<table_list.size(); i++){
		cout << table_list[i]->side << " " <<
			table_list[i]->banner << endl;
	}
#endif /* DEBUG_TABLE_DEFN */
	
	if(yyparse()){
		cout << "parsing axes failed" << endl;
		exit(1);
	}

	//print_ax_defn(ax_root);
	fstream ed_file("EDIT_OUT.RPT", ios_base::out|ios_base::trunc);
	if(!ed_file){
		cout << "failed to open EDIT_OUT.RPT ...exiting\n";
		exit(1);
	}
	//cout << "From main: tree_root: " << tree_root << endl;
	print_stmt_lst(tree_root, ed_file);
	//cout << "after print_stmt_lst\n";
	print_ax_map(ax_map);
	//cout << "after print_ax_map\n";
	//generate_code(ax_root);
	construct_tables(ax_map, table_list);
	printf("=============\n");
	printf("before: call to main_loop in main()\n");
	printf("=====================\n");
	printf("=====================\n");
	main_loop(ax_map, data_file_info, data_fname);
	fstream tab_("TAB_", ios_base::out|ios_base::trunc);
	print_table(tab_);
	//print_report(ax_root);
	//print_report(ax_map);
	fstream hct_("HCT_", ios_base::out);
	// I think iwth this for loop the counts will appear reversed
	for (int i=count_list_stack.size()-1; i!=-1; i--){
		//stmt_node * cnt_stmt = count_list_stack[i];
		count_stmt * cnt_stmt = count_list_stack[i];
		struct hole_count_container* hc_ptr = cnt_stmt->h_cont;
		hc_ptr->do_hole_count_summary();
		hc_ptr->print_hole_count(hct_);
	}
	check_tables(table_list);	
	//do_hole_count_summary();
	//print_hole_count();
	delete tree_root;
}

void print_ax_map(map<string, ax*>& ax_map) {
	//cout << "Enter print_ax_map():\n";
	typedef map<string, ax*>::const_iterator CMAPITER;
	fstream axmap("AX_MAP.RPT", ios_base::out|ios_base::trunc);
	if (!axmap){
		cerr << "failed to open AX_MAP.RPT for writing" << endl;
		exit(1);
	}
	for(CMAPITER m_iter=ax_map.begin();m_iter!=ax_map.end(); m_iter++){
		axmap << m_iter->first << endl;
		print_ax_stmt(m_iter->second->ax_stmt_start, axmap);
		//cout << "=*=*=*=*=*=\n";
	}
	//cout << "Exit print_ax_map():\n";
}


void print_ax_stmt(struct basic_ax_stmt * axis_stmt, fstream& axmap){
	//cout << "Enter :print_ax_stmt"	<< endl; 
       struct basic_ax_stmt * ax_stmt_ptr = axis_stmt;
       while(ax_stmt_ptr->next_ax_stmt) { ax_stmt_ptr=ax_stmt_ptr->next_ax_stmt; }
       while(ax_stmt_ptr){
		ax_stmt_ptr->print(axmap);
		//printf("COND: %s\n", ax_stmt_ptr->condition);
		ax_stmt_ptr = ax_stmt_ptr->prev_ax_stmt;

        }
	//cout << "Exit :print_ax_stmt"	<< endl; 
}
