#ifndef YAUAP_H
#define YAUAP_H 1


/* the player struct */
typedef struct player_s{
    void* yauap_priv;
    /* methods */
    int (*quit)(struct player_s* player);
    int (*pause)(struct player_s* player);
    int (*can_decode)(const char* url);
    int (*load)(struct player_s* player,const char* url);
    int (*stop)(struct player_s* player);
    int (*start)(struct player_s* player);
    unsigned int (*get_time_length)(struct player_s* player);
    unsigned int (*get_time_position)(struct player_s* player);
    int (*seek)(struct player_s* player,unsigned int offset);
    float (*get_volume)(struct player_s* player);
    int (*set_volume)(struct player_s* player,float volume);
    int (*get_metadata)(struct player_s* player,char ***metadata);
#define SCOPE_SIZE 2048
    /* get current scope buffer - data has to be at least SCOPE_SIZE bytes */
    int (*get_scopedata)(struct player_s* player,char * data);
    struct yauap_frontend_s* frontends[3];

} player_t;


typedef struct yauap_frontend_s {
    void (*free)(struct yauap_frontend_s* frontend);
#define SIGNAL_METADATA 1
#define SIGNAL_EOS      2
#define SIGNAL_ERROR    3
#define SIGNAL_SCOPEDATA 4
    void (*signal_cb)(struct yauap_frontend_s* frontend,unsigned int signal,char* message);
    void* priv;
    struct player_s* player;
} yauap_frontend_t;






#endif

