///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2008 Rene Jensen                                            //
//                                                                           //
// This file is part of YUV4MPEG Motion Tools (YUVMotionTools).              //
//                                                                           //
// Authors: Rene Jensen <centipede@takhis.net>                               //
//                                                                           //
// YUVMotionTools is free software: you can redistribute it and/or modify    //
// it under the terms of the GNU General Public License as published by      //
// the Free Software Foundation, either version 3 of the License, or         //
// (at your option) any later version.                                       //
//                                                                           //
// YUVMotionTools is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of            //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             //
// GNU General Public License for more details.                              //
//                                                                           //
// You should have received a copy of the GNU General Public License         //
// along with YUVMotionTools.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef FEATUREPOINT_H_INCLUDED
#define FEATUREPOINT_H_INCLUDED

#include <list>
#include <vector>
#include <opencv/cv.h>



using namespace std;





class FeaturePoint;

typedef vector<CvPoint2D32f>    points_t;
typedef list<FeaturePoint*>     featurepoints_t;
enum status_e {
    ALIVE,
    DEAD
};



class FeaturePoint
{
public:

    FeaturePoint (const CvPoint2D32f& startPoint, int firstframe);
    FeaturePoint (int index, int first, int last, int count, points_t& history);

    points_t::iterator  getPointsBeginIt ();
    points_t::iterator  getPointsEndIt   ();
    int                 getPointCount    ();
    status_e            getStatus        ();
    int                 getFirstFrame    ();
    int                 getLastFrame     ();
    CvPoint2D32f        getLatestPos     ();
    /// Use frame=-1 to get latest, -2 to get second latest etc. Use positive number or zero to get absolute frame number (i.e. frame >= firstFrame)
    CvPoint2D32f        getPosition      (int frame=-1);
    /// Use frame=-1 to get latest, -2 to get second latest etc. Use positive number or zero to get absolute frame number (i.e. frame >= firstFrame)
    CvPoint2D32f        getVelocity      (int frame=-1);
    /// Use frame=-1 to get latest, -2 to get second latest etc. Use positive number or zero to get absolute frame number (i.e. frame >= firstFrame)
    CvPoint2D32f        getAcceleration  (int frame=-1);
    /// A CvPoint. Useful for painting functions
    CvPoint             getPoint         ();

    CvScalar            getColor         ();
    void updateHistory (const CvPoint2D32f& pos, char status, float errorx, float errory);
    void updateDeltas (int currentFrame, float& dX, float& dY, float& weight);
    static void trackPoints (featurepoints_t& points, IplImage* oldImage, IplImage* newImage, IplImage* oldPyramidTmp, IplImage* newPyramidTmp);
    static featurepoints_t findNew (int howMany, IplImage* image, int frameStart, const CvSize& frameSize);

private:
    points_t        history;
    int             firstFrame;
    int             lastFrame;
    status_e        lifecycle;
    float           error_x;
    float           error_y;
};



#endif // FEATUREPOINT_H_INCLUDED
