///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2008 Rene Jensen                                            //
//                                                                           //
// This file is part of YUV4MPEG Motion Tools (YUVMotionTools).              //
//                                                                           //
// Authors: Rene Jensen <centipede@takhis.net>                               //
//                                                                           //
// YUVMotionTools is free software: you can redistribute it and/or modify    //
// it under the terms of the GNU General Public License as published by      //
// the Free Software Foundation, either version 3 of the License, or         //
// (at your option) any later version.                                       //
//                                                                           //
// YUVMotionTools is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of            //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             //
// GNU General Public License for more details.                              //
//                                                                           //
// You should have received a copy of the GNU General Public License         //
// along with YUVMotionTools.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef TRACKINGBUFFERS_H_INCLUDED
#define TRACKINGBUFFERS_H_INCLUDED

#include <opencv/cv.h>
#include <mjpegtools/mjpeg_types.h>

/// A control object which handles shifting between two buffers so that alternatingly one and the other is
///  seen as the front buffer
class TrackingBuffers
{
    bool        usingXformed;
    bool        frontIsOne;
    CvSize      size;
    int         counter;
    IplImage*   luma1;
    IplImage*   luma2;
    IplImage*   chromaSubs1;
    IplImage*   chromaSubs2;
    IplImage*   chroma1;
    IplImage*   chroma2;
    IplImage*   pyramid1;
    IplImage*   pyramid2;
    IplImage*   imageYUV;
    IplImage*   imageRGB;
    IplImage*   imageRGBxform;

public:
    TrackingBuffers (int width, int height, int subsampleX, int subsampleY);
    TrackingBuffers ();

    void        flip ();
    CvSize&     getSize ();
    int         getCounter ();
    IplImage*   getImageYUV  ();
    IplImage*   getImageRGB  ();
    IplImage*   getFrontLuma    ();
    IplImage*   getBackLuma     ();
    IplImage*   getFrontPyramid ();
    IplImage*   getBackPyramid  ();

    void        getBuffers (uint8_t*& luma, uint8_t*& chroma1, uint8_t*& chroma2);
    void        prepareForRead ();
    void        prepareForWrite ();
    void        translateRGB (float Tx, float Ty);
};


#endif // TRACKINGBUFFERS_H_INCLUDED
