#!/usr/bin/python

import math
import random

dat = file("/home/rene/Projects/code/stabilizer/testclip.data")

class Point:
    def __init__(self, pointId, frameStart, frameEnd, history):
        self.pointId, self.frameStart, self.frameEnd, self.history = pointId, frameStart, frameEnd, history
    def __repr__ (self):
        return "<Point #%d: %d-%d" % (self.pointId, self.frameStart, self.frameEnd)




def dist (Q,P,f):
    #print Q,P,f
    try:
        Qf = Q.history[ f-Q.frameStart ]
        Pf = P.history[ f-P.frameStart ]
        return math.sqrt ((Pf[0]-Qf[0])**2 + (Pf[1]-Qf[1])**2)
    except IndexError:
        print 'Index error somewhere: args to dist (Q,P,f):'
        print '   Q = %s' % Q
        print '   P = %s' % P
        print '   f = %d' % f
        raise




freePoints = []     # Points not yet clustered
freeGoodPoints = [] # Like the above, but without those points that only exist for a few frames



def init():
    global freePoints, freeGoodPoints

    while True:
        try:
            pointId, frameStart, frameEnd, historySize = [ int(i) for i in dat.readline().split() ]
        except ValueError:
            break # Done reading the file

        history = []
        for i in range(historySize):
            x,y = [ float(i) for i in dat.readline().split() ]
            history.append ( (x,y) )

        freePoints.append (Point (pointId, frameStart, frameStart + len(history), history))

    freeGoodPoints = [ p for p in freePoints if len(p.history)>=15 ]





def getCandidatePoints (frame):
    global freePoints, freeGoodPoints

    candidates = [ p for p in freeGoodPoints if frame <= p.frameStart and p.frameEnd >= frame+10 ]
    return candidates




def makeCluster ():

    if len(freeGoodPoints) == 0:
        return None, None

    frame = freeGoodPoints[0].frameStart
    clustered = []
    rejected = []

    # Initial: We try to build a cluster around a starting point. If this point turns out to be alone in space, then there
    # is no reason to believe that it will ever be useful. TODO: Throw it out from the global list of points
    candidates = getCandidatePoints (frame)
    clustered.append (candidates.pop(0))

    while True:

        #print 'CLUSTERED:..', len(clustered)
        #print 'REJECTED:...', len(rejected)

        candidates = [ p for p in getCandidatePoints (frame) if p not in clustered and p not in rejected ]

        #print 'CANDIDATES:.', len(candidates)

        if len(candidates) == 0:
            break


        i = 0
        while len(candidates) > 0:
            i += 1

            Q = candidates.pop(0)

            #frameUnion        = [ min ([ p.frameStart for p in cluster ]) , max ([ p.frameEnd for p in cluster ]) ]
            #frameIntersection = [ max ([ p.frameStart for p in cluster ]) , min ([ p.frameEnd for p in cluster ]) ]

            goodVouches = 0

            for P in clustered:

                first = max (Q.frameStart, P.frameStart)
                last  = min (Q.frameEnd, P.frameEnd)

                if last - first < 5:
                    continue

                distsOverFrames = [ dist(Q,P,f) for f in range(first, last) ]
                error = max (distsOverFrames) - min (distsOverFrames)
                if error > 5:
                    # Q is not going into this cluster!
                    #  Reject it and put it aside somewhere else
                    goodVouches = 0  # Make sure it becomes rejected
                    # print P, error
                    break
                else:
                    goodVouches += 1

            if goodVouches > 0:
                clustered.append (Q)
            else:
                rejected.append (Q)

            #print '  Cluster iteration: ', i
            #print '    Rejected...', len(rejected)
            #print '    Clustered..', len(clustered)

    # Return the gathered result

    return clustered, rejected




init()

clusters = []

while True:

    #print 'AVAILABLE: ', len(freeGoodPoints)

    clustered, rejected = makeCluster ()
    if clustered is None:
        break

    for p in clustered:
        freeGoodPoints.remove (p)

    clusters.append (clustered)
    print len(clustered)



## Make a collection of points and make a smaller list which only contains those points that have a history long enough (>=20) to be interesting
##  Next we cluster them together so that all points in a cluster maintain their individual distances.



