##############################################################################
=pod

=head1 NAME

basereactions actions of the bot, notably the toutou mode

=head1 DESCRIPTION

Here are specified the actions of the bot, notably the toutou mode.
It holds a reference on an anon sub array, and calls the given sub on presence
of the trigger as hashkey

The ressource files holding the ressources are fetched from
configpath/ressources with exeption if the path given begins with /

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  basereactions is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################

package zebot::basereactions;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);

use Data::Dumper;

# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

use POE::Session;

our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");

zebot::baseactor::_define_constructor("zebot::basereactions");

######################################################################
=pod

=item init

Initiaize, means set up this module

=cut

######################################################################
sub init
{
  my ($this, $botref) = @_;


  $this->SUPER::init($botref);
  $this->sysdata($botref);
  $this->setting("reactionsfile","reactions.pl") if(!($this->setting("reactionsfile"))); 
  $this->setting("operationsfile","operations.pl") if(!($this->setting("operationsfile"))); 


  my $path = $this->setting("reactionsfile"); 
  if(!($path =~ /^\//))
  {
    $path = $this->setting("configpath")."ressources/$path"; 
  }# if(!($root =~ /^\//))
  $this->loadReactions($path); 
  $path = $this->setting("operationsfile"); 
  if(!($path =~ /^\//))
  {
    $path = $this->setting("configpath")."ressources/$path"; 
  }# if(!($root =~ /^\//))
  $this->loadOperations($path); 
  #$this->print "load emotes ".$this->setting("emotesfile");
}#sub init

######################################################################
=pod

=item PRIVMSGaction

react on a message addressed directly to this script

=cut

######################################################################
sub PRIVMSGaction
{
  my ($this,$subargs) = @_;
  #return if($this->SUPER::activeForThisChan($subargs));
  if($this->SUPER::activeForThisChan($subargs))
  {
  $this->print("not active for this chan");
   return;
  }# if($this->SUPER::activeForThisChan($subargs))

  my $line = $subargs->{"line"};
  my $usernick = $subargs->{"usernick"};
  my $username = $subargs->{"username"};
  my $userhost = $subargs->{"userhost"};
  my $kernel = $subargs->{"kernel"};
  $this->{"kernel"} = $subargs->{"kernel"};
  $this->{"context"} = $subargs->{"context"};
  my $sysressource = $this->sysdata();

  my $botname = $subargs->{"heap"}->{"nick"};

  #$this->print "operator or not: '".$subargs->{"usernick"}."' = '".$this->setting("owner")."' in '$accessRights'";

  #check out if the user gave a channel ref prior to any command
  if ($line=~ /^\s*\#(\S+)\s+(.*)/ )
  {
    my $targetChan = $1;
   $this->print("preselection for channel $targetChan vs ".$subargs->{"channel"});
    $line = $2;
    $subargs->{"channel"} = "#$targetChan";
  }# if ($line=~ /^\s*\#(\S+)/ )
  elsif ($line=~ /^\s*(\S+)\s+\#(\S+)(.*)/ )
  {
    my $targetChan = $2;
   $this->print("preselection for channel $targetChan vs ".$subargs->{"channel"});
    $line = "$1 $3";
    $subargs->{"channel"} = "#$targetChan";
  }# if ($line=~ /^\s*\#(\S+)/ )
  $this->print("basereactions::raw line with subarsgs: $line");
    my $pam = ($this->sysdata())->{"actors"}->{"pam"};
    my $accessRights = $pam->findOperator($subargs);
    $this->print("basereactions::user acces: $accessRights for user ".$subargs->{"usernick"});

  if ($line=~ /^\s*(\S+)\s*(.*)|^\s*(\S+)/ )
  {
    my $commandtag = $1;
    my $restofline = $2;
    chomp $restofline;
    $subargs->{"command"} = $commandtag;
    $subargs->{"line"} = $restofline;

    $this->print("line with subarsgs: cmd = $commandtag, args=$restofline");

    #$this->print "operator or not: '".$subargs->{"usernick"}."' = '".$this->setting("owner")."'";
    #my $pam = ($this->sysdata())->{"actors"}->{"pam"};
    #my $accessRights = $pam->findOperator($subargs);

    #$this->print("user acces: $accessRights for user ".$subargs->{"usernick"});
    #if($accessRights && (index($accessRights,"owner") != -1 || index($accessRights,"oper") != -1))
    if($this->isOwnerOrOper($subargs))
    {
      my $owneractions = $this->{"owneractions"};
	print("OWNER action for $commandtag\n");
      if($owneractions->{$commandtag})
      {
	print("OWNER action we have it\n");
	&{$owneractions->{$commandtag}}($sysressource,$subargs);
	return 1;
      }
      else 
      { 
	return 1 if($this->processCmd($subargs));
      }

      #if($subargs->{"command"} eq "addemote")
      #{
      #  $this->addEmote($subargs);
      #}# if($commandtag eq "addemote")
    }#elsif ($sGens=~/$owner/) 
    else 
    { 
      $this->print( "NOT operator!");
      return 1 if($this->processCmd($subargs));

    }
  }# elsif ($restLine=~ /\s*(\S+)\s*(.*)/ )
  #$this->print "end line processing: $line";
  #     $this->print "basereactions ".Dumper($reactions)." didn't took ";
  #$this->post($usernick,"waff??? ($restLine)");

  return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my ($this, $splittedline) = @_;
  
  my $botname = $splittedline->{"heap"}->{"nick"};
  my $owneractions = $this->{"owneractions"};
  my $reactions = $this->{"reactions"};
  my $rest = $splittedline->{"line"};

  my $helpmsg = "BASE-help";
  my $pam = ($this->sysdata())->{"actors"}->{"pam"};
 my $accessRights = $pam->findOperator($splittedline);

    if($rest)
    {
      $helpmsg .= "[$rest]:\n";
      my $subhelp  = "";

      if($reactions->{$rest})
      {
	$subhelp .= "syntax is genreally $rest channel user further args";
      }# elsif if($reactions->{$rest})

      if(!$subhelp)
      {
	$subhelp = "no help for $rest\n";
      }#else
      return $helpmsg.$subhelp;
    }# if($rest)

  $helpmsg .= "!\n";
  #if(index($accessRights,"owner") != -1 || index($accessRights,"oper") != -1)
  if($this->isOwnerOrOper($splittedline))
  {

      foreach my $aCmd (keys(%$owneractions))
      {
	$helpmsg .= "$aCmd ";
      }# foreach my $aCmd (keys(%$owneractions))
      $helpmsg .= "\n";
      #$helpmsg .= "addemote trigger response\n";
  }# if($this->isOwnerOrOper())

    if($rest)
    {
      $helpmsg .= "help for $rest:\n";
      if($reactions->{$rest})
      {
	$helpmsg .= $reactions->{$rest};
      }# elsif if($reactions->{$rest})
      else
      {
	$helpmsg .= "no help for $rest\n";
      }#else
      return $helpmsg;
    }# if($rest)

    foreach my $aCmd (keys(%$reactions))
    {
      $helpmsg .= "$aCmd ";
    }# foreach my $aCmd (keys(%$reactions))
    #$helpmsg .= "listemote\n";
  return $helpmsg;
}#sub help

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "basereactions";
}#sub isa
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.22 $';
}#sub isa
#########################################################
=pod

=item processCmd

a command was identifyed try to make something out of it

=cut

#########################################################
sub processCmd
{
  #my ($this,$commandtag,$line) = @_;
  my ($this,$line) = @_;
  my $sysressource = $this->sysdata();
  #my $emotes = $this->{"emotes"};
  my $reactions = $this->{"reactions"};

  my $kernel = $line->{"kernel"};
  $this->{"kernel"} = $line->{"kernel"};
  $this->{"context"} = $line->{"context"};

  my $commandtag = $line->{"command"};

  $commandtag =~ tr/[A-Z]/[a-z]/ ;
  my $channel = $line->{"channel"};
 $this->print( "--- processCMd: chan=$channel cmd=$commandtag line=".$line->{"line"});
  #$this->print "--- processCMd: chan=$channel cmd= $commandtag line=".Dumper($line)."\n";


  if ($reactions->{$commandtag})
  {
    #$this->post($line->{"usernick"},"success for $commandtag\n");
    &{$reactions->{$commandtag}}($this, $channel, $line);
    return 1;
  }
  return 0;
}#sub processCmd  
#########################################################
=pod

=item loadReactions 

load the file with the basic reactions of the bot

=cut

#########################################################
sub loadReactions 
{
  my ($this,$line) = @_;
  if($line)
  {
    if(-f $line)
    {
      my $reactions = do $line; 
      $this->{"reactions"} = $reactions;
    }# if(-f $line)
    else
    {
      $this->print("Hey dude, what about giving a valid filename instead of $line?");
    }# else
  }# if($line)
  else
  {
    $this->print("Hey dude, what about giving a filename or source reactions come from?");
  }# else
}# sub loadReactions 
#########################################################
=pod

=item loadOperations 

load the bot-operator stuff

=cut

#########################################################
sub loadOperations 
{
  my ($this,$line) = @_;
  my $owneractions = do $line; 
  $this->{"owneractions"} = $owneractions;
  #$this->print "Official end of reactions!!";
}# sub loadOperations 
#########################################################
=pod

=item dumpReactions

make s listing of the actual loaded reactions

=cut

#########################################################
sub dumpReactions 
{
  my ($this) = @_;
  my $i;
  my $listing = "";
  if($this->{"reactions"})
  {
    my $theActions = $this->{"reactions"};
    foreach $i (keys(%$theActions))
    {
      $listing .= $i." ";
      $listing .= $theActions->{$i} if($theActions->{$i}) ;
      $listing .= "\n";
    }# foreach $i (keys(%theActions))
  }# if($this->{"reactions"})
  return $listing;
}
#########################################################
=pod

=item saveReactions

write the actual simple reactions to the file

=cut

#########################################################
sub saveReactions 
{
  my ($this,$line) = @_;
  open (REACTIONS, ">".$line) || die("couldn't open $line");
  print REACTIONS dumpReactions();
  close (REACTIONS);
}
#########################################################
=pod

=item sysdata

getter for for the holder instance with the global data and methods

=cut

#########################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
#########################################################
=pod

=item shutdown

closing operations, saving emotes!

=cut

#########################################################
sub shutdown
{
  my $this = shift;
  $this->save();
}#sub shutdown
#########################################################
=pod

=item save 

save the datastructures if needed, preparation of a shutdown, or a saveguard point...

=cut

#########################################################
sub save 
{
  my ($this) = @_;
  #$this->saveEmotes();
  return 0;
}# sub save
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

