##############################################################################
=pod

=head1 NAME

fileserver for zebot

=head1 DESCRIPTION

IRC fileserver for zebot

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  fileserver.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::fileserver;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);
use DBI;

use Data::Dumper;


# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

use POE::Session;

our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");
zebot::baseactor::_define_constructor("zebot::fileserver");
my $dsn = 'DBI:Pg:dbname=zebot';
my $dsname = 'bboett';


###############################################################################
#	Welcome & help messages
###############################################################################

my @welcome_msg = (
  "",
  "         -=[ FServe for zebot        ]=-         ",
  "",
  " i am interested in any of the anime requested   ",
  " in the banner, and to fill all gaps i have in my", 
  " incomplete series, its no use to chat to this   ",
  "  bot, if you want to chat go for bboett         ",
  "                                                 ",
  "   Commands: ls/dir get dequeue clr_queue queue  ",
  "             read help sends who stats quit      ",
  "                                                 ",
  "             Type help for more info             ",
  "                                                 ",
  ""
);

my @help_msg = (
  "-=[ Available commands ]=-",
  "  ls / dir       - list files in current directory",
  "  get <file>     - inserts <file> into the queue",
  "  read <file>    - displays contents of <file>",
  "  dequeue <nr>   - removes file in slot <nr>",
  "  clr_queue[s]   - removes your queued files",
  "  queue[s]       - lists the queue",
  "  sends          - lists active sends",
  "  who            - lists users online",
  "  stats          - shows some statistice",
  "  quit           - closes the connection",
);

my @srv_help_msg = (
  "command - [params] description\003\n",
  "on      - [0] enables fileserver",
  "off     - [0] disables fileserver",
  "save    - [0] save config file",
  "load    - [0] load config file",
  "saveq   - [0] saves sends/queue",
  "loadq   - [0] loads the queue",
  "set     - [2] sets variables",
  "insert  - [2] inserts a file in queue",
  "move    - [2] moves queue slots around",
  "clear   - [1] removes queued files",
  "queue   - [0] lists file queue",
  "sends   - [0] lists active sends",
  "who     - [0] lists users online",
  "stats   - [0] shows server statistics",
  "recache - [0] updates filecache\003\n",
  "Usage: /fs <command> [<arguments>]",
  "For parameter info type /fs <cmd>",
);

###############################################################################
#	fileserver preferences (/fs set <var> <data>)
#	default values, feel free to change them
###############################################################################
my %fs_prefs = (
  max_users 	=> 5,
  max_sends 	=> 1,
  max_queue	=> 20,
  user_slots	=> 3,
  min_cps		=> 3000,
  idle_time	=> 120,
  max_time	=> 600,
  ignore_msg	=> 1,
  ignore_chat     => 1,
  ops_priority    => 0,

  notify_interval => 900,
  auto_save	=> 600,

  log_name        => 'logfile',	
  trigger		=> '!bboettsAnime',
  channels	=> '#animextacy',
  root_dir	=> '/video',
  note		=> 'requests go to bboett',
  logo		=> 'bboetts fserver',

  clr_txt		=> "\00314",
  clr_hi		=> "\00312",
  clr_file	=> "\00315",
  clr_dir		=> "\00312",

  "maxread"	=> 30000
);

###############################################################################
#	fileserver statistics
###############################################################################
my %fs_stats = (
  record_cps	=> 0,
  rcps_nick	=> "",
  sends_ok	=> 0,			# sends succeeded
  sends_fail	=> 0,			# sends failed
  transfd		=> 0,			# total bytes transferred
  login_count	=> 0,			# total number of logins
);

my @fs_queue = ();
my @fs_failqueue = ();
my @fs_sends = ();
my %fs_users = ();

###############################################################################
#	private variables, don't set to any values
###############################################################################
my $fs_debug = 0;
my $fs_enabled = 0; 	# always start disabled
my $online_time = 0;	# time since last script restart
my $timer_tag;
my $server_tag = "";
my %fs_cache = ();
my $logfp;
my @kill_dcc;


#$dbh = undef;

######################################################################
=pod

=item init

Initialize, means set up this module

=cut

######################################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;
   my $sysrefe = $sysref;
   # $this->print("this = $this\n");
   # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");


  $this->SUPER::init($sysref);
   $this->sysdata($sysref);


}#sub init

######################################################################
=pod

=item PUBLICaction

react on a message addressed directly to this script

=cut

######################################################################
sub PUBLICaction
{
  my ($this,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  my $botname = $splittedline->{"heap"}->{"nick"};
  $this->print("fileserver debug '$botname': received $line\n");

  my $accessRights = findOperator($this,$splittedline);
  $this->print("fileserver debug '$botname': rights= $accessRights\n");
  if($this->isOwnerOrOper($splittedline))
  {
    $this->print("fileserver debug '$botname': has rights !\n");
    #$this->post( $kernel, $usernick,'user is owner or oper');
  }#if($this->isOwnerOrOper())
  return 0;
}#sub PUBLICaction
######################################################################
=pod

=item PRIVMSGaction

react on a message addressed directly to this script

=cut

######################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  my $botname = $splittedline->{"heap"}->{"nick"};
  $this->print("fileserver debug '$botname': received $line\n");

  my $accessRights = findOperator($this,$splittedline);
  $this->print("fileserver debug '$botname': rights= $accessRights\n");
  if($this->isOwnerOrOper($splittedline))
  {
    $this->print("fileserver debug '$botname': has rights !\n");
    #$this->post( $kernel, $usernick,'user is owner or oper');
  }#if($this->isOwnerOrOper())
  return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item JOINaction

react on a user joining

=cut

######################################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  ##removing the hostname of the jostpart, for dynamic addressing
  #my @hostparts = split(/\./,$userhost);
  #shift @hostparts;
  #$userhost = join('.',@hostparts);
  $this->print("someone joins: $usernick $username\@$userhost\n");
  #bail out if its the same bot joinning
  my $botname = $splittedline->{"heap"}->{"nick"};
  if($usernick eq $botname) 
  {
    return 0;
  }

  return 0;
}#sub JOINaction
######################################################################
=pod

=item PARTaction

react on a user leaving

=cut

######################################################################
sub PARTaction
{
  my ($this,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  return 0;
}#sub PARTaction
######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my $this = shift;
  my $splittedline = shift;
  my $botname = $splittedline->{"heap"}->{"nick"};
  # $this->print("m6: search for $usernick\n");
  # $this->print("ref = '$splittedline'\n");
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  my $list = findOperator($this,$splittedline);
    my $helpmsg = "FS-help:\n";
  if($list ne "")
  {
    $helpmsg   .= "   dummy cmd: add some help here\n";
    return $helpmsg;
  }#if($list ne "")
  else 
  { 
     $helpmsg .= "user $usernick, $username\@$userhost is not ";
     $helpmsg .= "Operator, help not available!\n";
     #$helpmsg .= "result query gave: $list";
    return $helpmsg;
  }
}#sub help

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "fileserver";
}#sub isa
######################################################################
=pod

=item findLogged

search for the online status of someone

=cut

######################################################################
sub findLogged
{
  my $this = shift;
  my $nick = shift;

  my $sql_query = 'SELECT * FROM users where ';
  $sql_query .= "\"nick\"='$nick' AND logged='t'";

  my $sth = $this->doQuery($nick,$sql_query);
  if( $sth->rows != 0)
  {
    return 1;
  }#if( $sth->rows == 0)
  return 0;
}# sub findLogged
######################################################################
=pod

=item shutdown

close down the activity for a safe shutdown

=cut

######################################################################
sub shutdown
{
   my $this = shift;
  my $owner = $this->setting("owner");
}#sub shutdown
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.14 $';
}#sub isa

######################################################################
=pod

=item DCCdone

success of a dcc transfer

=cut

######################################################################
sub DCCdone
{
  my ($this,$subargs) = @_;

  # my $subargs = {
  #   "kernel" => $kernel,
  #   "usernick" =>$nick,
  #   "username" =>$name,
  #   "userhost" =>$host,
  #   "magic" =>$magic,
  #   "type" =>$type,
  #   "file" =>$file,
  #   "port" =>$port,
  #   "size" =>$size,
  #   "done" =>$done,
  # };
  # $this->print("DCC $type to $nick ($file) done: $done bytes transferred.\n");
}#sub DCCdone
######################################################################
=pod

=item DCCerror

failure of a dcc transfer

=cut

######################################################################
sub DCCerror
{
  my ($this,$subargs) = @_;

  # my $subargs = {
  #   "kernel" => $kernel,
  #   "usernick" =>$nick,
  #   "username" =>$name,
  #   "userhost" =>$host,
  #   "error" =>$err,
  #   "type" =>$type,
  #   "file" =>$file,
  # };

  # $this->print("DCC $type to $nick ($file) failed: $err.\n");
}#sub DCCerror
######################################################################
=pod

=item DCCrequest

proposal of a DCC transfer

=cut

######################################################################
sub DCCrequest
{
  my ($this,$subargs) = @_;

  # my $subargs = {
  #   "kernel" => $kernel,
  #   "usernick" =>$nick,
  #   "username" =>$name,
  #   "userhost" =>$host,
  #   "magic" =>$magic,
  #   "type" =>$type,
  #   "file" =>$filename,
  #   "port" =>$port,
  #   "size" =>$size,
  # };
  # $this->print("DCC $type request from $nick on port $port magic='$magic'\n");
  #$nick = ($nick =~ /^([^!]+)/);
  #$nick =~ s/\W//;
  #$kernel->post( 'test', 'dcc_accept', $magic, "$1.$filename" );
}#sub 

1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

