##############################################################################
=pod

=head1 NAME

operators_pg

=head1 DESCRIPTION

operator module, op, deop etc users on a given channel
  using the a postgres database

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  operators_pg.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::operators_pg;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use Data::Dumper;
use POSIX qw(strftime);

our @ISA = ("zebot::baseactor");
#attributes("operators_pg","deb");
zebot::baseactor::_define_constructor("zebot::operators_pg");

#########################################################
=pod

=item init

initalize the module

=cut

#########################################################
sub init
{
  my @securedargs = @_;
  my $this = shift;
  my $sysref = shift;

  my $sysrefe = $sysref;
  #$this->print "obj = $this\n";
  $this->SUPER::init($sysref);
  $this->sysdata($sysref);
  $sysref->{"instmodules"}->{"operators_pg"} = $this;
}#sub init
#########################################################
=pod

=item JOINaction

a user join, check his rights and issue eventually appropriated steps 

=cut

#########################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"restLine"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  foreach my $i (keys(%{$this->sysdata()->{"instmodules"}}))
  {
   $this->print("deb2: mod = $i ->".$this->sysdata()->{"instmodules"}->{$i}."\n");
  }#foreach $i (keys(%$this->sysdata()->{"instmodules"}))

  my $pam = $this->sysdata()->{"instmodules"}->{"pam"};
  #$this->print "m5: search for $usernick\n";
  my $list = $pam->findOperator($splittedline);
  if(index($list,"owner") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' :ACTION places at feet of his god: '.$usernick.'' );
    ::SendServer( 'MODE '.$splittedline->{"channel"}.' +o '.$usernick );
    return 0;
  }#if($list ne "")
  elsif(index($list,"oper") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' :ACTION dances around '.$usernick.'' );
    ::SendServer( 'MODE '.$splittedline->{"channel"}.' +o '.$usernick );
    return 0;
  }#if($list ne "")
  elsif(index($list,"ally") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' :ouaf ouaf '.$usernick.'!' );
    return 0;
  }#if($list ne "")
  elsif(index($list,"tekki") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' :ACTION bites a big piece out of '.$usernick.'\'s private parts' );
    return 0;
  }#if($list ne "")
  #SendServer( 'PRIVMSG '.$channel.' : ouaf ouaf  '.$reconstructed );
  return 0;
}#sub JOINaction
#########################################################
=pod

=item PARTaction

a user leaves, issue an appropriated leave message

=cut

#########################################################
sub PARTaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"restLine"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  my $pam = $this->sysdata()->{"instmodules"}->{"pam"};
  #$this->print "m5: search for $usernick\n";
  my $list = $pam->findOperator($splittedline);
  if(index($list,"owner") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' :AAAouuuuuuuuuuuuuuhhhh!!!');
  }#if($list ne "")
  elsif(index($list,"oper") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' :Fiiiiiii!!! '.$usernick);
  }#if($list ne "")
  elsif(index($list,"ally") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' : fiiiiii '.$usernick.'!' );
  }#if($list ne "")
  elsif(index($list,"tekki") != -1) 
  {
    ::SendServer( 'PRIVMSG '.$splittedline->{"channel"}.' : Waf Waf!! '.$usernick);
  }#if($list ne "")
  #SendServer( 'PRIVMSG '.$channel.' : ouaf ouaf  '.$reconstructed );
  return 0;
}#sub PARTaction
#########################################################
=pod

=item help

issue the usage for  this module

=cut

#########################################################
sub help
{
  my $this = shift;
  my $splittedline = shift;
  my $botname = $splittedline->{"heap"}->{"nick"};
  #$this->print "m6: search for $usernick\n";
  #$this->print "ref = '$splittedline'\n";
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  my $pam = $this->sysdata()->{"instmodules"}->{"pam"};
  #$this->print "m5: search for $usernick\n";
  my $list = $pam->findOperator($splittedline);
  #$this->print "help, req by $usernick $username\@$userhost\n";
  #$this->print "full-line was ".$splittedline->{"fulline"}."\n";
    my $helpmsg = "Operator-help:\n";
  if(index($list,"owner") != -1 || index($list,"oper") != -1) 
  {
    $helpmsg   .= "   no commands available\n";
    return $helpmsg;
  }#if($list ne "")
  else 
  { 
    $helpmsg .= "user $usernick, $username\@$userhost is not ";
    $helpmsg .= "Operator, help not available!\n";
    #$helpmsg .= "result query gave: $list";
    return $helpmsg;
  }
}#sub help
#########################################################
=pod

=item isa

issue the type of this module

=cut

#########################################################
sub isa
{
  return "operators_pg";
}#sub isa
#########################################################
=pod

=item shutdown

prepare the object for its imminent death

=cut

#########################################################
sub shutdown
{
  my $this = shift;
  my $owner = $this->setting("owner");
}#sub shutdown
#########################################################
=pod

=item version

issue the version of this module

=cut

#########################################################
sub version
{
  return '\$Revision: 1.14 $';
}#sub isa


1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

