#!/usr/bin/perl -w
##############################################################################
#  operator operations of the bot
#  author Bruno BTTCHER <bboett at adlp.org>
#  Copyright (c) 2002 Bruno Boettcher
#
# zebot is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################
sub POE::Kernel::ASSERT_EVENTS () { 1 };
sub POE::Kernel::ASSERT_STATES () { 1 };
sub POE::Kernel::ASSERT_DEFAULT () { 1 };
use POE::Kernel;
use POE::Session;
use Data::Dumper;
use XML::Simple;
use strict;

sub BEGIN
{
    #push (@INC,$ENV{HOME}.'/',$ENV{HOME}.'/ircbots')
    #      if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/ircbots/));
    #push (@INC,$ENV{HOME}.'/',$ENV{HOME}.'/ircbots/zebot')
    #      if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/ircbots\/zebot/));
    my $pwd = $ENV{PWD};
    my @fullpath = split('/',$pwd);
    pop @fullpath;
    my $pwdup = join('/',@fullpath);
    push (@INC,$pwdup)
          if(!( (join(' ',@INC)) =~ /$pwdup/));
    #we also need to include .., since our modules are searched in zebot/*
    #print "added $pwdup to path\n";
    push (@INC,$pwd)
          if(!( (join(' ',@INC)) =~ /$pwd/));
    #print "added also $pwd to path\n";
}
sub SendServer
{
  my $line = shift;
  print "SendServer: $line\n";
}#sub SendServer

my $settings = {
   "configpath" => "$ENV{HOME}/.zebot/",			#path to configfiles
           "botname" => "toutou",
           "owner" => "Lasade",
           "originhost" => "kalman.u-strasbg.fr",
           "fullname" => "Laureline de Monmarchel",
           "ircserver" => "irc.skroz.net",
           "streamName" => 'botlog',
           "reconnect" => 1,
           "operatorfile" => "users.conf",
           "channel" => "#sps",
           "emotesfile" => "zebot.emotes",
           "userfile" => "passwd",
           "actornames" => ["mailbox"],
           "reactionsfile" => "reactions.pl",
           "operationsfile" => "operations.pl",
   "ownerpass" => "toto",
   "xmlreactionsfile" => "res_emotes.xml",
   "xmlmessagesfile" => "res_messages.xml",
   "language" => "fr",
   "rejoininterval" => 60,
   "reconnectinterval" => 60,
   "debug" => 1,
           "instmodules" => {},
   "database" => 'DBI:Pg:dbname=zebot',
   "dbuser" => 'bboett'
               };

my $tester = new zebot::test();
print("tester is a ".ref($tester)."\n");
$tester->{"settings"} = $settings;
print("tester is still a ".ref($tester)."\n");
$tester->loadSettings(); 
print("tester is it? : ".ref($tester)."\n");

my %systemres;
$tester->{"modules"} = [];
$tester->{"actors"} = {};

#my $line = "<<-- :Lasade!~bboett\@serf-35315.cybercable.tm.fr PRIVMSG toutou :query first";
#my $line = "<<-- :Lasade!~bboett\@serf-35315.cybercable.tm.fr PRIVMSG toutou :query 1";
my $line = { "usernick" =>"Lasade", 
             "username"=>"bboett", 
             "userhost"=>"serf-35315.cybercable.tm.fr",
             "command" => "PRIVMSG", 
             "fulline" => "whole line",
             "restLine"=> "toutou :mail aos test one" 
             };
my $line2 = { "usernick" =>"Lasade2", 
              "username"=>"bboett", 
              "userhost"=>"serf-35315.cybercable.tm.fr",
              "command" => "PRIVMSG", 
             "fulline" => "whole line",
              "restLine"=> "toutou :mail aos test two" 
             };
my $linec = { "usernick" =>"Lasadec", 
              "username"=>"bboett", 
              "userhost"=>"serf-35315.cybercable.tm.fr",
             "fulline" => "whole line",
              "command" => "JOIN", 
              "restLine"=> ":#fm" 
            };



#use mailbox;
#$file = "dbaccess";
#$file = "mailbox";
#$file = "mailbox_pg";
#my $file = "operators";
#eval("use $file");
#my $cmd = 'new '.$file.'()';
#print "trying to eval $cmd\n";
#my $first = eval($cmd);
#use operators;
#my $first = new operators();
print "loading i8n\n";
use zebot::messageHandler;
my $MSobj = new zebot::messageHandler();
$tester->{"actors"}->{$MSobj->isa()} = $MSobj;
print "loading PAM\n";
use zebot::pam;
my $pam = new zebot::pam();
print "loading basereactions\n";
use zebot::basereactions;
my $BRobj = new zebot::basereactions();
print "loading mailbox_pg\n";
use zebot::mailbox_pg;
my $MBobj = new zebot::mailbox_pg();
print "loading operators_pam\n";
use zebot::operators_pam;
my $OPobj = new zebot::operators_pam();
#use download;
#my $DLobj = new download();
print "loading testmod\n";
use zebot::testmod;
my $TMobj = new zebot::testmod();
 print "loading baseactor\n";
 use zebot::baseactor;
zebot::baseactor::_define_constructor("zebot::baseactor");
 my $BAobj = new zebot::baseactor();

my $genObj = undef;
use zebot::dbaccess;
$genObj = new zebot::dbaccess();

use zebot::emoteparser;
$genObj = new zebot::emoteparser();

use zebot::fileserver;
$genObj = new zebot::fileserver();

use zebot::ircServer;
$genObj = new zebot::ircServer();

use zebot::mailbox;
$genObj = new zebot::mailbox();

use zebot::operators;
$genObj = new zebot::operators();

use zebot::operators_pg;
$genObj = new zebot::operators_pg();

use zebot::pam_pg;
$genObj = new zebot::pam_pg();

use zebot::triggers;
$genObj = new zebot::triggers();

#$settings->{"instmodules"} = {};
my $tempRef = $settings->{"instmodules"};
$tempRef->{"none"} = "toto";

my $sysref = $tester->{"settings"};
#print "YYYYYYYYY\n";
#print Dumper($systemres{"modules"});
#print "YYYYYYYYY\n";

$pam->init($tester);
print "BRobj inint:\n";
$BRobj->init($tester);
print "MBobj inint:\n";
$MBobj->init($tester);
print "OPobj inint:\n";
$OPobj->init($tester);
print "MSobj inint:\n";
$MSobj->init($tester);
#print "DLobj inint:\n";
#$DLobj->init($tester);
#print "TMobj inint:\n";
#$TMobj->init($tester);
#print "BAobj inint:\n";
#$BAobj->init($tester);

use zebot::dummypam;
$genObj = new zebot::dummypam();
print "DUMMYPAM inint:\n";
$genObj->init($tester);

use zebot::downloader;
$genObj = new zebot::downloader();
print "MEDOWN init:\n";
$genObj->init($tester);

#use zebot::connector;
#$genObj = new zebot::connector();
#print "MECON init:\n";
#$genObj->init($tester);

#print "dumping modules:\n";
#foreach my $i (keys(%{$settings->{"instmodules"}}))
#{
#  print("test: mod = $i ->".$settings->{"instmodules"}->{$i}."\n");
#}#foreach $i (keys(%$obj->sysdata()->{"instmodules"}))${*

print "here:".$pam->help($line)."\n";
print "next round\n";
$pam->PRIVMSGaction($line);
$pam->PRIVMSGaction($line2);
print "next round\nsending join!\n";
$pam->JOINaction($linec);
#print("finished parsing dumping langtree:".$MSobj->dumpLangs()."\nend\n");
print($MSobj->getMesg("FIRESERVHAND")."\n");
#print($MSobj->dumpXML()."\n");
#$second->JOINaction($linec);
print "finished join \n";
#$pam->shutdown($pam,$linec);
$poe_kernel->run();


package zebot::test;
use Data::Dumper;
use XML::Simple;

sub new 
{
  my $this = bless {}, "zebot::test";
  #print("SPAWNER CTOR incoming args: ".Dumper(\@_)."\n");
  return $this;
}
sub setting 
{
  my ($this,$key,$value) = @_;
  if(!$value)
  {
    return $this->{"settings"}->{$key};
  }# if ($key)
  $this->{"settings"}->{$key} = $value;
}#setting
#########################################################
=pod

=item loadSettings

load form the conf file the different bot settings

=cut

#########################################################
sub loadSettings 
{
  my ($this) = @_;

  my $basepath = $this->{"settings"}->{"configpath"};
  $basepath .= "/" if(!($basepath =~ /\/$/));
  $basepath .= "config/";

  print("loadSettings for $basepath\n");
  my $subsettings = {};

  if(opendir(DIRLIST,$basepath))
  {
    my @dirlisting = grep { /\.conf|\.xml$/ && -f "$basepath/$_" }readdir(DIRLIST);
    foreach my $filename (@dirlisting) 
    {
      print("found config file : $filename\n");
      if($filename =~ /(.*?)\.conf$/)
      {
	my $actor = $1;
	my $actorSets = {};
	#print("found a hash for $actor\n");
	$filename = $basepath .$filename;
	$this->loadHash($filename,$actorSets);
	#print("Loaded for $actor: ".Dumper($actorSets)."\n");
	$subsettings->{$actor} = $actorSets;
      }# if($filename =~ /\.conf$/)
      elsif($filename =~ /(.*?)\.xml$/)
      {
	#print("XML configuration files aren't parsed for the moment\n");
        my $actor = $1;
        my $actorSets = {};
        $actorSets = XMLin($basepath."$filename");
        #print "dumping config:\n".Dumper($actorSets)."\n";
        print( "DUMPING config keys:\n".join(' ',keys(%$actorSets))."\n");
        
      }# elsif($filename =~ /(.*?)\.xml$/)
    }#foreach $filename (@dirlisting) 

    closedir(DIRLIST);
  }# if(opendir(DIRLIST,$lpath))
  else
  {
    print("zebot::loadSettings couldn't open the configdir:'$basepath'!!!\n");
    die("You didn't read the documentation!!\n");
  }# else
  # throwing out the hashes of subsettings that aren't needed
  my $actorSettings = $subsettings->{"actors"};
  my @actornames = keys(%$actorSettings);
  $this->{"actornames"} = \@actornames;
  #cleanse the actor settings from the records that have no real data
  foreach my $name (@actornames)
  {
    if($actorSettings->{$name} != 1)
    {
      $this->{"settings"}->{"subsettings"}->{"actors"}->{$name} = $actorSettings->{$name};
    }# if($actorSettings->{$name} != 1)
  }# foreach my $name (@actornames)
  #throw this out of further processing
  delete $subsettings->{"actors"};
  #merge the zebot stuff with the general settings
  foreach my $name (keys(%{$subsettings->{"zebot"}}))
  {
   $this->{"settings"}->{$name} = $subsettings->{"zebot"}->{$name};
  }# foreach my $name (keys(%{$subsettings->{"zebot"}}))
  #throw this out of further processing
  delete $subsettings->{"zebot"};
  #add the remaining stuff to the subsettings
  foreach my $subset (keys(%$subsettings))
  {
    if($subsettings->{$subset} && scalar(keys(%{$subsettings->{$subset}})) >0)
    {
    $this->{"settings"}->{"subsettings"}->{$subset} = $subsettings->{$subset};
    }# if($subsettings->{$subset})
  }# foreach my $subset (keys(%$subsettings))
  #remove temporary structures
  delete $this->{"tmpsettings"};
}# sub loadSettings 
#########################################################
=pod

=item loadHash

suppose a file organized line wise with
key value
open the file, read it in, aprse each line for those key value pairs and add
them to the hash of settings


if lines are empty or prepended with a # ignore them

=cut

#########################################################
sub loadHash
{
  my ($this,$filename,$params) = @_;

  if(open (SETTINGS, $filename))
  {
  #print "-- loadSettings over settings ".Dumper($this->{"settings"})."\n";
    while(<SETTINGS>)
    {
      chomp( $_ );
      my $tagname;
      my $value;
      if(/^#/ || /^\s*$/ || /^\s*\{|^\s*\}/)
      {
	#ignore....
      }
      elsif(/^(\S+)\s+(.*)$/)
      {
	$tagname = $1;
	$value = $2;
	#print "setting $tagname to $value\n";
	$params->{$tagname} = $value if(!($value =~ /^HASH/));
      }#if(/\w+:\w+:\w+.*/)
      elsif(/^(\S+)/)
      {
	$tagname = $1;
	$value = 1;
	#print "setting $tagname to $value\n";
	$params->{$tagname} = $value;
      }#if(/\w+:\w+:\w+.*/)
    }#while(<SETTINGS>)
    close (SETTINGS);
  }#if(open (SETTINGS, "zebot.conf"))
  else
  { print("zebot::loadHash couldn't open $filename\n");}
}# sub loadHash
