#!/usr/bin/perl
##############################################################################
=pod

=head1 NAME

LogView 

=head1 DESCRIPTION

start up a GtkText widget and allows to pipe text into it, keeping the cursor at the bottom, and handling all the gtk relevant stuff...

=head1 AUTHOR

  Bruno Bttcher <bboett at adlp dot org>

=head1 COPYRIGHT and LICENCE

 Copyright (c) 2002 Bruno Boettcher

 LogView.pl is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; version 2
 of the License.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=cut

##############################################################################
package Gtk2::LogBuffer;
use warnings;
use strict;
use Gtk2;

use Data::Dumper;

our @ISA = qw(Gtk2::TextBuffer);

use constant FALSE => 0;
use constant TRUE => 1;
######################################################################
=pod

=item new 

constructor for the load configuration object
first arg settings, second optional tagtable

=cut

######################################################################
sub new 
{
  my ($fs,$hashref,$tagtable) = @_;
  my $obj_ref;
  $obj_ref = Gtk2::TextBuffer->new($tagtable);
  #$obj_ref = SUPER::new($tagtable);

  $obj_ref->{"settings"} = $hashref if ($hashref);
  $obj_ref->{"settings"} = {} if (!$hashref);

  $obj_ref->create_tag ("blue", foreground => "blue");;
  $obj_ref->create_tag ("red", foreground => "red");;
  $obj_ref->create_tag ("yellow", foreground => "yellow");;


  bless $obj_ref, "Gtk2::LogBuffer";


  $obj_ref->jump_to_buffer_end();
  return $obj_ref;
}# sub new 
######################################################################
=pod

=item jump_to_buffer_end 

move the visible cursor to the end of the window

=cut

######################################################################
sub jump_to_buffer_end 
{
  my($this) = @_;
  my($start, $end) = $this->get_bounds;
  my $mark = $this->create_mark("", $end, FALSE);
  $this->{"view"}->scroll_to_mark($mark, 0, TRUE, 0.0, 1.0) if($this->{"view"});
  $this->delete_mark($mark);
}#sub jump_to_buffer_end 
######################################################################
=pod

=item add_with_tag 

takes as argument an array ref, color is hidden between ctrl-C at the end of
the line.

=cut

######################################################################
sub add_text 
{
  my($this,$text) = @_;
  if(ref($text) eq 'ARRAY')
  {
    foreach my $line (@$text)
    {
      my $color;
      if($line =~ /^(.*?)(.*?)$/)
      {
	$line = $1;
	$color = $2;
      }
      $this->add_line($line,$color);
    }# foreach my $line (@$text)
  }# if(ref($text) eq 'ARRAY')
}#sub add_with_tag 
######################################################################
=pod

=item add_line 

insert a line at the end of the buffer and provque a scroll to the end of line,
  second argument is optional and is the name of one of the predefined colors.

if settings bufferlength is set, reduce the buffer to that size if we exceed

=cut

######################################################################
sub add_line 
{
  my($this,$text,$color) = @_;
  #$text .= "\n" if(!($text =~ /\n$/));
  my $settings = $this->{"settings"};

  #insert at end
  my $iter = $this->get_iter_at_offset (-1);
  if($color)
  {
    $this->insert_with_tags_by_name($iter,$text,$color);
  }# if($color)
  else
  {
    $this->insert($iter,$text);
  }# else

  #cut down the buffer
  my $linesToRemove = $this->get_line_count() - $settings->{"bufferlength"};
  if($linesToRemove > 0)
  {
    $iter = $this->get_iter_at_offset (0);
    $iter->forward_lines($linesToRemove);
    $iter->forward_to_line_end();

    $this->delete($this->get_iter_at_offset (0),$iter);
  }# if($linesToRemove > 0)

  $this->jump_to_buffer_end();
}#sub add_line 
######################################################################
=pod

=item set_view 

Set the actual view this buffer is attached to

=cut

######################################################################
sub set_view 
{
  my($this,$view) = @_;
  $this->{"view"} = $view;
}#sub set_view 


1
__END__


=back

=head1 THANKS

=head1 SEE ALSO

http://poe.perl.org/

=cut
