##############################################################################
=pod

=head1 NAME

federating 

=head1 DESCRIPTION

root of all actors, all modules to be used within this bot have to inherit from this (abstract) class.

=head1 LICENCE

  baseactor is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut


##############################################################################
package zebot::baseactor;
use strict;
use Encode 'from_to';

sub BEGIN
{
    # $this->print("BEGIN zebot::baseactor\n");
    # $this->print("include path is : ".Dumper(\@INC)."\n");
}

# sub POE::Kernel::ASSERT_DEFAULT() { 1 }
# sub POE::Kernel::ASSERT_PONY() { 1 }
# sub POE::Kernel::ASSERT_EVENTS() { 1 }
# sub POE::Kernel::ASSERT_STATES() { 1 }

use POE::Kernel;
use POE::Session;

use Data::Dumper;
#use ObjectTemplate;
#@ISA = ("ObjectTemplate");
#attributes("sysdata");

######################################################################
#### constructor for the new irc-server handler object
######################################################################
# sub new 
# {
#   my ($this) = @_;
#   my $o_FserverHandler = { };
#
#   bless $o_FserverHandler, "baseactor";
#   return $o_FserverHandler;
# }# sub new 
##############################################################################
=pod

=item init

initialisation of the baseactor

=cut


##############################################################################
sub init
{
  my ($this,$botref) = @_;
  # $this->print("baseactor::".$this->isa()." init\n");
  $this->{"zebot"} = $botref;
  #print("class is ".ref($this)."\n");
  my @classSplit = split(/::/,ref($this));
  #print("plit is ".Dumper(\@classSplit)."\n");
  my $rawname = pop(@classSplit);
  #lower classes may override setting to make special stuff, let them parse the
  #config files altogether
  #$this->{"subsettings"} = $botref->{"settings"}->{"subsettings"}->{$rawname};

  my $subset = $botref->{"settings"}->{"subsettings"}->{$rawname};
  foreach my $key (keys(%{$subset}))
  {
    $this->setting($key,$subset->{$key});
  }# foreach my $key (keys(%{$subset}))

  #load eventual text ressources needed by this module
  my $path = $this->setting("configpath")."ressources/";
  if($this->setting("messages"))
  {
    $path .= $this->setting("messages") ;
  }
  else
  {
    $path .= "res_".$this->isa().".xml" ;
  }# else
  my $msgHand = $botref->module("messageHandler");
  $msgHand->load($path) if(-e $path);
  #print($this->isa()." init with settings:".Dumper($this->{"subsettings"})."\n");
  # $this->print("baseactor::init bot? ".Dumper($botref));
  #POE::Session->new( $this->isa() =>
  #    [ qw( _start _stop _default)
  #    ],
  #    );
  # $this->print("baseactor::".$this->isa()." session defined\n");
  return 0;
}#sub init
##############################################################################
=pod

=item setArgument

in the modules files there were evenutally some switches for this module,
  ovverride this one to get a grip on them and to parse them, they come in raw,
  as a result of the split of the lines in the actors.conf

=cut


##############################################################################
sub setArgument
{
  my ($this,$args) = @_;
  return 0;
}#sub setArgument
#########################################################
=pod

=item activeForThisChan

check if we are active for this chan, return true if we are false otherwise
special case the private channel to the bot is allways open

=cut

#########################################################
sub activeForThisChan
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  my $heap = $args->{"heap"};
  # $this->print("baseactor::active bot? ".Dumper($this->{"zebot"}));
  #print("START of heap dump\n");
  #foreach my $key (%{$heap})
  #{
  #  print("heapvalue $key = ". $heap->{$key}."\n");
  #}# foreach my $key (%{$heap})
  #print("end of heap dump\n");

  my $botname = $heap->{"nick"};
  if(!$botname)
  {
    print("ARRRRGGS activeForThisChan no botname in ".Dumper($heap)."\n");
    return 1;
  }# if(!$botname)
  #my $activeChans = $this->{"zebot"}->{"activeChans"};
  #my $ownChans = $heap->{"channels"};
  #$this->print("baseactor::active[$botname] $channel vs $activeChans or ".Dumper($heap)."\n");
  # $this->print("baseactor::active[$botname] $channel vs $activeChans\n");
  #$this->print("no channel defined\n") if(!$channel);
  #$this->print("channel equal to botname\n") if($botname eq $channel);
  #$this->print("channel is active chan") if($activeChans =~ /\Q$channel\E/i);
  #$this->print("checking activity for $channel, test valid?\n");
  return 0 if(!$channel);
  #$this->print("checking for botname?\n");
  return 0 if($botname eq $channel);
  #$this->print("checking for presence in ".Dumper($heap)."?\n");
  #return 0 if($heap->{"channels"}->{lc($channel)});
  return 0 if($heap->{"actives"}->{lc($channel)}->{"all"});
  return 0 if($heap->{"actives"}->{lc($channel)}->{$this->isa()});
  #return 0 if($activeChans =~ /\Q$channel\E/i);
  #$this->print("seems this channel is unknwon...?\n");
  return 1;
}# sub activeForThisChan
#########################################################
=pod

=item activate

make this module active for a given channel

=cut

#########################################################
sub activate
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  my $lang = $args->{"lang"};
  my $heap = $args->{"heap"};

  $heap->{"actives"}->{lc($channel)}->{$this->isa()} = 1;
}# sub activate
#########################################################
=pod

=item deactivate

stop this module for a given channel

=cut

#########################################################
sub deactivate
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  my $lang = $args->{"lang"};
  my $heap = $args->{"heap"};

  delete($heap->{"actives"}->{lc($channel)}->{$this->isa()});
}# sub deactivate
##############################################################################
=pod

=item CONNaction

the bot managed to connect to some server

=cut


##############################################################################
sub CONNaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
   
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub CONNaction
##############################################################################
=pod

=item PINGaction

keep alive event to test the connection with the server

=cut


##############################################################################
sub PINGaction
{
  return 0;
}#sub PINGaction
##############################################################################
=pod

=item PONGaction

coutner part of the ping action

=cut


##############################################################################
sub PONGaction
{
  return 0;
}#sub PONGaction
##############################################################################
=pod

=item MODEaction

some user changed modes for some other user

=cut


##############################################################################
sub MODEaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub MODEaction
##############################################################################
=pod

=item NOTICEaction

some notice was issued on a channel

=cut


##############################################################################
sub NOTICEaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub NOTICEaction
##############################################################################
=pod

=item PUBLICaction

a message was sent onto a public channel

=cut


##############################################################################
sub PUBLICaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub PUBLICaction
##############################################################################
=pod

=item PRIVMSGaction

a private message was detected

=cut


##############################################################################
sub PRIVMSGaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub PRIVMSGaction
##############################################################################
=pod

=item KICKaction

some nasty kicking is happening

=cut


##############################################################################
sub KICKaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub KICKaction
##############################################################################
=pod

=item PARTaction

some user left the realm of this bot

=cut


##############################################################################
sub PARTaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub PARTaction
##############################################################################
=pod

=item JOINaction

some user joined the realm of this bot

=cut


##############################################################################
sub JOINaction
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub JOINaction
##############################################################################
=pod

=item shutdown

close down operations i sight of bot shutdown r reload of these modules

=cut


##############################################################################
sub shutdown
{
  return 0;
}#sub shutdown
##############################################################################
=pod

=item isa

issue the type of this object

=cut


##############################################################################
sub isa
{
  return "baseactor";
}#sub isa
##############################################################################
=pod

=item version

issue the version of this module

=cut


##############################################################################
sub version
{
  return '$Revision: 1.34 $';
}#sub isa
##############################################################################
=pod

=item post

post a message as private message directed to a target (channel or user)

=cut


##############################################################################
sub post
{
  my ($this,$nick, $msg) = @_;
  my $kernel = $this->{"kernel"};
  my $context = $this->{"context"};
  #$this->print( "basactor::post kernel=". $this->{"kernel"}."\n" );
  #$this->print( "basactor::post context='$context'" );
  my $mode = 'privmsg';

  if($context)
  {
    #backpropagation!! we asked inside the program to send us back something..
    if($context =~ /\@/)
    {
      ($mode, $context) = split(/\@/,$context);
      #print("posting with remaining args:".Dumper(\@_)."\n");
      if(ref($msg) ne "HASH")
      {
	print("cretin oublie de changer l'envoi de msg de $msg!!\n");
      }# if(ref($msg) ne "HASH")
      $kernel->post( $context, $mode, $msg);
      return;
    }
  }# if($context =~ /@/)

  #ircmode, we don't need the rest of the info
      $msg = $msg->{"line"} if(ref($msg) eq "HASH");

    my @text = split(/\n/,$msg);
    if($kernel)
    {
      foreach my $line (@text)
      {

	#from_to($line, "utf-8","iso-8859-1");
	if($nick && $line)
	{
	  $kernel->post( $context, $mode, $nick,$line);
	}# if($nick && $line)
	else
	{
	  $this->print("oy post needs 2 args, org msg was: '$msg' act line was u:l->'$nick':'$line'\n") if(!$msg);
	}
      }# foreach my $line (@text)
      #$this->print("issuing post to $context with 'privmsg' and $nick soste $msg\n");
    }#if ($kernel)
    else
    {$this->print("$nick $msg\n");}
  return 0;
}
##############################################################################
=pod

=item dccChat

post a message as private message directed to a target through DCC

=cut


##############################################################################
sub dccChat
{
  my ($this,$args, $msg) = @_;
  my $kernel = $args->{"kernel"};
  my $context = $args->{"context"};
  #$this->print( "pam::post kernel=". $this->{"kernel"}."\n" );
  my $magic = $args->{"magic"};
  if(!$magic)
  {
    $this->post($args->{"nick"}, $this->getMesg("You need to supply a magic cooky for DCC CHAT you dork"));
    return;
  }# if(!$magic)

  my @text = split(/\n/,$msg);
  if($kernel)
  {
    foreach my $line (@text)
    {
      if($line)
      {
	$kernel->post( $context, 'dcc_chat', $magic,$line);
      }# if($nick && $line)
      else
      {
	my $arg = {"rest" => $msg };
    $this->post($line->{"nick"}, $this->getMesg("oy dccchat needs something to post: 'rest'",$arg));
      }
    }# foreach my $line (@text)
    #$this->print("issuing post to $context with 'privmsg' and $nick soste $msg\n");
  }#if ($kernel)
  else
  {$this->print("DCC chat: $msg\n");}
  return 0;
}# sub dccChat
##############################################################################
=pod

=item part

leave a channel

=cut


##############################################################################
sub part
{
  my ($this,$channel) = @_;
  my $kernel = $this->{"kernel"};
  my $context = $this->{"context"};
  #$this->print( "pam::post kernel=". $this->{"kernel"}."\n" );

  if($kernel)
  {
    $kernel->post( $context, 'part', $channel);
    #$this->print("issuing post to $context with 'privmsg' and $nick soste $msg\n");
  }#if ($kernel)
  return 0;
}#part
##############################################################################
=pod

=item quit

leave this server

=cut


##############################################################################
sub quit
{
  my ($this, $msg) = @_;
  my $kernel = $this->{"kernel"};
  my $context = $this->{"context"};

  if($kernel)
  {
 $this->print( "basactor::quit posting quit with $msg\n" );
    $kernel->post( $context, 'quit', $msg);
    #$this->print("issuing post to $context with 'privmsg' and $nick soste $msg\n");
  }#if ($kernel)
  return 0;
}#part
##############################################################################
##############################################################################
=pod

=item raw

print out a raw string wihtout trying to interpret it

=cut


##############################################################################
sub raw
{
  my ($this,$mode,$nick, $msg) = @_;
  my $kernel = $this->{"kernel"};
  my $context = $this->{"context"};

  if ($kernel)
  {
    $kernel->post( $context, $mode, $nick,$msg);
  }#if ($kernel)
  else
  {$this->print("ACTION $nick $msg\n");}
  return 0;
}
##############################################################################
=pod

=item action

some action /emote was issued

=cut


##############################################################################
sub action
{
  my ($this,$nick, $msg) = @_;
  my $kernel = $this->{"kernel"};
  my $context = $this->{"context"};

  if ($kernel)
  {
    my @lines = split(/\n/,$msg);
    foreach my $line (@lines)
    {
      #from_to($line, "utf-8","iso-8859-1");
      $kernel->post( $context, 'privmsg', $nick,'ACTION '.$line.'');
    }
  }#if ($kernel)
  else
  {$this->print( "ACTION $nick $msg\n");}
  return 0;
}
##############################################################################
=pod

=item kick

remove a user from a channel

=cut


##############################################################################
sub kick
{
  my ($this,$channel,$nick, $msg) = @_;
  my $kernel = $this->{"kernel"};
  my $context = $this->{"context"};

  if ($kernel)
  {
    $kernel->post( $context, 'kick', $channel,$nick,$msg);
  }#if ($kernel)
  else
  {$this->print( "KICK $channel $nick $msg\n");}
  return 0;
}# sub kick
##############################################################################
=pod

=item mode

modechane event

=cut


##############################################################################
sub mode
{
  my ($this,$splittedline) = @_;
  return if($this->activeForThisChan($splittedline));
  #$this->print("we are active ...\n");

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  #my ($this,$kernel,$context,$nick, $msg) = @_;
  my $msg = "";
  $msg .= " ".$splittedline->{"channel"};
  $msg .= " ".$splittedline->{"mode"};
  $msg .= " $usernick";
  if ($kernel)
  {
    $kernel->post( $splittedline->{"context"}, 'mode', $msg);
    #$kernel->post( $splittedline->{"context"}, 'mode', $nick,$msg);
  }#if ($kernel)
  else
  {$this->print( "ACTION $usernick $msg\n");}
  return 0;
}# sub mode
##############################################################################
=pod

=item DCCget

intermediary success of a running transfer

=cut


##############################################################################
sub DCCget
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 0;
}#sub DCCget
##############################################################################
=pod

=item DCCchat

Dcc chat incoming

=cut


##############################################################################
sub DCCchat
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 0;
}#sub DCCchat
##############################################################################
=pod

=item DCCdone

success of a dcc transfer

=cut


##############################################################################
sub DCCdone
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 0;
}#sub DCCdone
##############################################################################
=pod

=item DCCerror

# failure of a dcc transfer

=cut

##############################################################################
sub DCCerror
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 0;
}#sub DCCerror
##############################################################################
=pod

=item DCCrequest

proposal of a DCC transfer

=cut


##############################################################################
sub DCCrequest
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 0;
}#sub 
##############################################################################
=pod

=item uncatched

all the rest

=cut

##############################################################################
sub uncatched
{
  my $this = shift;
  #my $msg =  "uncatched :".$this->isa().":";
  #foreach my $i (@_)
  #{  $msg .= $i." "; }
  #$msg .= "\n";
  # $this->print($msg);
  return 0;
}#sub uncatched
##############################################################################
=pod

=item help

help accessor

=cut

##############################################################################
sub help
{
  my ($this,$line) = @_;
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $token = uc($this->isa());
  $token .= "HELP";

  my $msg = $msgHand->getMesg($token,$line);
  return $msg if($msg);
  return $this->isa().$msgHand->getMesg(":no help available",$line)."\n";
}#sub help
#########################################################
=pod

=item _start 

This gets executed as soon as the kernel sets up this session.

=cut

#########################################################
# sub _start 
# {
#   my ($kernel, $session,$context) = @_[KERNEL, SESSION,SENDER];
#   my $this = shift;
#
#   # Uncomment this to turn on more verbose POE debugging information.
#   # $session->option( trace => 1 );
#
#   # Make an alias for our session, to keep it from getting GC'ed.
#   $kernel->alias_set( $this->isa() );
#
#   # Ask the IRC component to send us all IRC events it receives. This
#   # is the easy, indiscriminate way to do it.
#   $kernel->post( 'mainframe', 'register', 'all');
#   $kernel->post( $this->isa(), 'register', 'all');
#   $kernel->post( $context, 'register', 'all');
#   $this->print("baseactor::".$this->isa()." started\n");
#
# }# sub _start 
#########################################################
=pod

=item _stop

This gets executed as soon as the kernel stops this session.

=cut


#########################################################
# sub _stop
# {
#   my $this = shift;
#   my ($kernel, $session) = @_[KERNEL, SESSION];
#
#   $this->print("baseactor::".$this->isa()." stopped\n");
# }# sub stop
#########################################################
=pod

=item _default 

the stuff  that couldn't be identifyed

=cut


#########################################################
# sub _default 
# {
#   return 0;
# }

#########################################################
=pod

=item _define_constructor 

construcor builder taken from ObjectTemplate

=cut


#########################################################
sub _define_constructor
{
    my $pkg = shift;
    my $code = qq {
        package $pkg;
        sub new {
            my \$class = shift;
            my \$this = bless {}, \$class;
	    \$this->{"activeChans"} = "";
            #\$this->set_attributes(\@_) if \@_;
            #\$this->initialize;

            return \$this;
        }
    };
    eval $code;
    $code;
}# sub _define_constructor
#########################################################
=pod

=item irc_ctcp_action

react on a CTCP action command

=cut


#########################################################
sub irc_ctcp_action
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub irc_ctcp_action
#########################################################
=pod

=item addChannel

add a channel to which this object should react

=cut


#########################################################
sub addChannel
{
  my ($this,$newChan,$defaultlang,$heap) = @_;
  #my $activeChans = $this->{"zebot"}->{"activeChans"};
  $heap->{"channels"}->{lc($newChan)}->{$defaultlang};
  #if(!$activeChans =~/\Q$newChan\E/i)
  #{
  #  $activeChans .= " $newChan";
  #}# if(!$this->{"activeChans"} =~/\Q$newChan\E/i)
}# sub addChannel
#########################################################
=pod

=item rmChannel

remove a channel to which this object did react

=cut


#########################################################
sub rmChannel
{
  my ($this,$newChan,$heap) = @_;
  #my $activeChans = $this->{"zebot"}->{"activeChans"};
  #$activeChans =~ s/\Q$newChan\E//gi;
  #$activeChans =~ s/  / /gi;
  delete $heap->{"channels"}->{lc($newChan)};
}# sub rmChannel
#########################################################
=pod

=item debug

issue debugginh messages to the console

=cut


#########################################################
sub debug
{
  my ($this,$msg) = @_;
  $msg = $this if(!$msg);
 $this->print("$msg\n");
}# sub debug
#########################################################
=pod

=item$this->print

delegator, to make a copy of the console stream to a file, for debugging purposes only, since somehow the STDOUT gets swallowed up for some cases....

=cut

#########################################################
sub print
{
  my ($this,$msg) = @_;
  $msg = $this if(!$msg);
  if(open(FILE,">>logger"))
  {
   print FILE ("$msg\n");
    close(FILE);
  }# if(open(FILE,">logger"))
 print("$msg\n");
}# sub$this->print
#########################################################
=pod

=item saveToFile 

save the given string to the given file, first arg is filename, second the
content to save

=cut


#########################################################
sub saveToFile 
{
  my ($this, $filename, $data) = @_;
  open (FILE, ">$filename") || die("couldn't open $filename");
  print FILE $data;
  close (FILE);
}# sub saveToFile 
#########################################################
=pod

=item save 

save the datastructures if needed, preparation of a shutdown, or a saveguard point...

=cut


#########################################################
sub save 
{
  my ($this) = @_;
  return 0;
}# sub save
#########################################################
=pod

=item isOwnerOrOper 

this test is done an awful amount of times, and is ugly to look at...
its tested if there are some access rights fr that user, and if they correspond to either owner or operator status

=cut


#########################################################
sub isOwnerOrOper 
{
  my ($this, $subargs) = @_;
  my $pam = ($this->sysdata())->module("pam");
  my $accessRights = $pam->findOperator($subargs);

  return 1    if($accessRights && (index($accessRights,"owner") != -1 || index($accessRights,"oper") != -1));
  return 0;
}# sub save
##############################################################################
=pod

=item join_success

we managed to join safely a channel

=cut


##############################################################################
sub join_success
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  #$this->print("this is baseactor::join_success!! for ".$this->isa()."\n");
  #return 0 if(!($this->activeForThisChan($args)));
  return 0;
}#sub join_success
#########################################################
=pod

=item setting 

setter/getter for the settings, to be able to choose any format for those
settings without disturbing the rest of the program... when getting it tries
the local hash first, if it matches that value is returned, if not the call is
propagaed to the mainframe. On set it is checked if that setting exists
globally, if yes its propagated, if not its set locally, BEWARE this means you
can't set new settings on the mainframe through this method!

=cut

#########################################################
sub setting 
{
  my ($this,$key,$value) = @_;

  my $botref =  $this->{"zebot"};

  if(!$key)
  {
    #make a dump of the settings
    my $msg = "Settings of Module ".$this->isa()."\n";
    foreach $key (sort(keys(%{$this->{"subsettings"}})))
    {
     $msg .= "$key: ".$this->{"subsettings"}->{$key}."\n"
         if(ref($this->{"subsettings"}->{$key}) eq ""); 
    }# foreach $key (keys(%$this))
    return($msg);
  }# if(!$key)

  if($value)
  {
    if($botref->setting($key))
    {
      #its a global setting 
      return $botref->setting($key,$value);
    }# if($botref->setting($key))
    else
    {
      #local setting
      $this->{"subsettings"}->{$key} = $value;
      return;
    }
  }# if ($key)

  if($this->{"subsettings"}->{$key})
  {
    return $this->{"subsettings"}->{$key};
  }# if ($key)

  return $botref->setting($key,$value);
}#setting
#########################################################
=pod

=item session 

some of those modules have an own session running, this conflicts eventually
with some modus operandi, thus in case you run a session in a module give it
the name $this->{"alias"}, this name will be returned here as possible target
for posts, one method that will definitely use this is the shutdown call

=cut

#########################################################
sub session 
{
  my ($this,$value) = @_;

  if($value)
  {
      $this->{"alias"} = $value;
  }# if ($key)
  else
  {
    return $this->{"alias"};
  }# if ($key)
}#getSession
1
__END__


=back

=head1 AUTHOR 

Bruno BTTCHER <bboett at adlp.org>

Copyright (c) 2002 Bruno Boettcher

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
Net::IRC, 
RFC 1459,
http://www.irchelp.org/, 
http://poe.perl.org/
http://www.cs.cmu.edu/~lenzo/perl/, 
http://www.infobot.org/,


=cut


