#!/usr/bin/perl
package zebot::client::Connector;
##############################################################################
=pod

=head1 NAME

zebot::client::Connector

=head1 DESCRIPTION

handler to make the connection with a SSL server and translate the local events
into far events and inversely. Connects on demand to the server and uses
Storable objects to pass the data as references between both. Casts off local
events on returning data-hashes if they hold postback-data


=head1 AUTHOR

  Bruno Bttcher <bboett at adlp dot org>

=head1 COPYRIGHT and LICENCE

 Copyright (c) 2002 Bruno Boettcher

 patternQuery.pl is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; version 2
 of the License.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=head1 Methods of this class 

=over 

=cut

##############################################################################
use warnings;
use strict;
use Data::Dumper;

use POE;
use POE::Filter::Reference;

##############################################################################
=pod

=item connectWithServer

prepare the connection with the Server, set up all callback to be ready
as soon as the POE system is started

=cut

######################################################################
sub connectWithServer
{
  my ($this,$hrefs,$kernel) = @_[OBJECT,ARG0, KERNEL];
  push(@{$this->{"jobs"}}, $hrefs);
  print("connectWithServer \n");
  #POE::Component::Client::TCP->new
  if(scalar(@{$this->{"jobs"}}))
  {
    if($this->{"connected"})
    {
      #$this->print("connection buildup casting sendBatch  to $this->{name}\n");
      $kernel->post($this->{"name"}, "sendBatch" );
      return;
    }# if($this->{"connected"})

    $this->print("connecting with server ");
    $this->print("with ".$this->setting("host").":".$this->setting("port")."\n");

    #use POE::Component::Client::SSL;
    use ClientTcp;
    my $clientSocket = 
      #POE::Component::Client::SSL->new
      ClientTcp->new
      ( 
       Alias => $this->{"tcpalias"},
       RemoteAddress => $this->setting("host"),
       RemotePort    => $this->setting("port"),
       Filter        => "POE::Filter::Reference",
       SSL => 1,

       # Build a request and send it.

       Connected => sub {
	 my($kernel,$heap) = @_[KERNEL,HEAP];
	 $this->connected($kernel,$heap);
       },

       # Receive a response, display it, and shut down the client.

       ServerInput => sub {
	 my($kernel,$heap,$arg) = @_[KERNEL,HEAP,ARG0];
	 $this->got_response($kernel,$heap,$arg);
       },
       sendBatch => sub {
	 my($kernel,$heap,$arg) = @_[KERNEL,HEAP,ARG0];
	 $this->sendBatch($kernel,$heap,$arg);
       },
       #could reach the server....
       ConnectError => sub {
	 my($kernel,$heap,$arg) = @_[KERNEL,HEAP,ARG0];
	 $this->disconnected($kernel,$heap,$arg);
       },
       Disconnected => sub {
	 my($kernel,$heap,$arg) = @_[KERNEL,HEAP,ARG0];
	 $this->disconnected($kernel,$heap,$arg);
       },
       );
  }# if(scalar(@{$this->{"jobs"}}))
  else
  {
    $this->print("no queries to submit to the server...\n");
    #bail out...
    $this->print("bailing out to ".$this->{"defaultSession"}." at ".$this->{"defaultEvent"}."\n");
    $kernel->post($this->{"defaultSession"}, $this->{"defaultEvent"},$this->{"torrents"}); 
  }# else

}#sub connectWithServer
##############################################################################
=pod

=item connected

we are now connected with the server, login and cast an event if there is
allready some data outstanding

=cut
######################################################################
sub connected
{
  my ($this,$kernel,$heap) = @_;
  $this->{"connected"} = 1;
  $this->{"server"} = $heap->{server};

  #$this->print("connected!! obj is ".ref($this)."\n");
  $this->print("connected!!\n");
  my $cmd = {
    #"addressed"=> "pam",
    "line"	=> "auth ".$this->setting("passwd"),
    "usernick"	=>         $this->setting("user"),
    "username"	=>         $this->setting("realname"),
    "userhost"	=>         $this->setting("host"),
    "lang" 	=>         $this->setting("lang"),
    #"network"	=> $heap->{"network"},
    "channel"	=> "pam", #hope we have only one channel target...
    "context"	=> "print@".$this->{"name"},
  };

  my @request = ( 
      $cmd
      );

    my $job = {
      "requests"	=> \@request,
      "session"		=> $this->{"name"},
      "msgevent"	=> "print",
    };
  unshift(@{$this->{"jobs"}},$job);

  $this->print("shell initialized send out: ".Dumper(\@request)."\n");
  #$heap->{server}->put( \@request );
  #$_[KERNEL]->delay( sendBatch => 1 );
  #$this->print("connection success casting sendBatch  to $this->{name}\n");
  $kernel->post($this->{"name"}, "sendBatch" ) if(!($this->{"actjob"}));
  #$this->print("connected! posted sendBatch\n");
}#sub connected
##############################################################################
=pod

=item got_response

the server send us a response, this should be dispatched to its receipient

=cut
######################################################################
sub got_response
{
  my ($this, $kernel, $heap, $hash ) = @_;

  #$kernel->post('delegate',"hello");

  if ( !$hash) 
  {
    #ignore empty lines...
    $this->print("got empty input....!\n");
  }
  elsif ( ref($hash) eq 'HASH' ) 
  {
    push(@{$this->{"actjob"}->{"result"}}, $hash);
  }
  elsif ( ref($hash) eq 'SCALAR' ) 
  {
    #$this->print("Client received:".$$hash."\n");
    if($$hash =~ /jobDone/i)
    {
      $this->{"jobcount"}--;
      #$this->print("jobDone actual count :$this->{jobcount}\n");
      if($this->{"jobcount"} <= 0)
      {
	$this->{"jobcount"} = 0; 
	my $actJob = $this->{"actjob"};

	if($actJob)
	{
	  if($actJob->{"session"} && $actJob->{"event"} && $actJob->{"result"})
	  {
	    $kernel->post($actJob->{"session"}, $actJob->{"event"}, $actJob->{"result"}); 
	  }# if session && event && result
	  elsif($actJob->{"session"} && $actJob->{"msgevent"})
	  {
	    $kernel->post($actJob->{"session"}, $actJob->{"msgevent"}, $hash); 
	  }# elsif($actJob->{"session"} && $actJob->{"msgevent"})
	  #$this->print("jobdone deleting ".Dumper($this->{"actjob"})."\n");
	  delete $this->{"actjob"};
	}# if($actJob)
	$kernel->post($this->{"name"}, "sendBatch"); 
      }#if($this->{"jobcount"} <= 0)
    }# elsif($$hash =~ /jobDone/i)
    else
    {
      $this->print("don't know how to handle $$hash\n for actJob:".Dumper($this->{"actjob"})."\n");
	my $actJob = $this->{"actjob"};
      if($actJob->{"session"} && $actJob->{"msgevent"})
      {
	$kernel->post($actJob->{"session"}, $actJob->{"msgevent"}, $hash); 
      }# if($actJob->{"session"} && $actJob->{"event"} && $actJob->{"result"})
      else
      {
	$kernel->post($this->{"defaultSession"}, $this->{"msgevent"}, $hash); 
      }# if($actJob->{"session"} && $actJob->{"event"} && $actJob->{"result"})
    }# else
  }# elsif ( ref($hash) eq 'SCALAR' ) 
  else 
  {
    #$this->print("Client received an unknown response type: ", ref($hash), "
    #with $hash\n");
    $this->print("Client received an unknown response type: ". ref($hash). " with $hash\n");
  }
  #$kernel->yield("shutdown");
}#sub got_response
##############################################################################
=pod

=item sendBatch

send out the whole list of requests

=cut
######################################################################
sub sendBatch
{
  my ($this, $kernel, $hash ) = @_[OBJECT,KERNEL,ARG0];
  #$this->print("sendBatch sending the stuff \n");
  if($this->{"actjob"})
  {
    #$this->print("watcha calling me? still running ".$this->{"actjob"}->{"event"}."\n");
    $this->print("watcha calling me? still running ".Dumper($this->{"actjob"})."\n");
    if($this->{"actjob"}->{"tmout"} && time() > $this->{"actjob"}->{"tmout"})
    {
     $this->print("job ".Dumper($this->{"actjob"})." tmouted\n"); 
     my $actJob = $this->{"actjob"};
	    $kernel->post($actJob->{"session"}, $actJob->{"event"}, $actJob->{"result"}); 
     delete($this->{"actjob"});
    }# if($this->{"actjob"}->{"tmout"} && time() > $this->{"actjob"}->{"tmout"})
    #just to be sure, recall this one a bit later
    my $delay = $this->setting("batchdelay") * 60;
    $_[KERNEL]->delay( sendBatch => $delay, $hash );
    return 0;
  }# if($this->{"actjob"})

  my $nextJob = shift(@{$this->{"jobs"}});
  if($nextJob)
  {
    #$this->print("client::Connector next job: ".Dumper($nextJob));
    my $requests = $nextJob->{"requests"};
    #forget oneshot requests
    $this->{"actjob"} = $nextJob if($nextJob->{"session"});


    while(@$requests)
    {
      my @request;
      for(my $i = 0; ($i < 20) && @$requests; $i++)
      {
	push(@request, shift(@$requests)); 
      }#for(my $i = 0; ($i < 20) && @$requests; $i++)
      $this->{"jobcount"}++ if($nextJob->{"session"});
      #$this->print("sendBatch posting job".Dumper(\@request)."\n");
      $this->{"server"}->put( \@request );
      @request = ();
    }# while(@$requests)
  }# if($nextJob)
  else
  {
    #$this->print("sendBatch: no more jobs\n");
    #$this->print("reporting back to ".$this->{"defaultSession"}." at ".$this->{"defaultEvent"}."\n");
    $_[KERNEL]->post($this->{"defaultSession"}, $this->{"defaultEvent"},$this->{"torrents"}); 
  }# else
  return 1;
}# sub sendBatch
##############################################################################
=pod

=item startSession

start our own session to be able to have timered stuff

=cut
######################################################################
sub startSession
{
  my ($this) = @_;
  POE::Session->create
    (
     object_states =>
     [
     $this => { 
     _start         => "_start",
     _stop         => "_stop",
     "shutdown" => "shutdown",
     sendBatch => "sendBatch",
     "pushToServer" => "connectWithServer",
     "print" => "print_ev",
     }
  ]
    );
}# sub startSession
##############################################################################
=pod

=item _start

to keep this session alive set an alias

=cut
######################################################################
sub _start
{
  my ($this, $kernel, $arg ) = @_[OBJECT, KERNEL, ARG0 ];
  $_[KERNEL]->alias_set($this->{"name"});
  print("kernel start for connector\n");
  $kernel->yield("pushToServer");
}# sub _start
##############################################################################
=pod

=item _stop

to keep this session alive set an alias

=cut
######################################################################
sub _stop
{
  my ($this, $kernel, $arg ) = @_[OBJECT, KERNEL, ARG0 ];
  $this->print("stopping series connector...\n");
  #exit(0);
}# sub _stop
##############################################################################
=pod

=item shutdown

close this session

=cut
######################################################################
sub shutdown
{
  my ($this, $kernel, $arg ) = @_[OBJECT, KERNEL, ARG0 ];
  #$this->print("shutdown extract torrents...\n");
  delete $this->{"server"};
  undef $this->{"server"};
  #shut down the ssl client
  $_[KERNEL]->post($this->{"tcpalias"}, "shutdown"); 
  #$kernel->yield("shutdown");
  #$this->print("TCP client should now shutdown\n");
  $_[KERNEL]->alias_remove($this->{"name"} );
  exit();
}# sub shutdown
##############################################################################
=pod

=item init

Initiaize, means set up this module

=cut

######################################################################
sub init
{
  my ($this,$settings,$arguments) = @_;

  $this->{"settings"} = $settings;

  #print("Connector initializing with ".Dumper($this->{"settings"})."\n");
  print("Connector initializing \n");
  $this->{"subsettings"} = $this->{"settings"}->{"subsettings"}->{"connector"};


   $this->setting("address","localhost") if(!($this->setting("address")));
   $this->setting("port","22045") if(!($this->setting("port")));



  $this->{"jobcount"} = 0;
  #fetch the stuff from the file
  $this->{"tcpalias"} = "tcpClient";


  foreach my $key (keys(%$arguments))
  {
    $this->{$key} = $arguments->{$key};
  }# foreach my $key (keys($arguments))

  print("connector init! starint sessions\n");
  $this->startSession();
}#sub init
##############################################################################
=pod

=item CTOR

instantiation of the Helper

=cut

##############################################################################
sub new 
{
  my($class,$sessionname) = @_;
  my $this = bless {}, "zebot::client::Connector";
  $this->{"name"} = "anon session".time;
  $this->{"name"} = $sessionname if($sessionname);
  return $this;
}
##############################################################################
=pod

=item disconnected

somehow we lost the connection...

=cut

##############################################################################
sub disconnected 
{
  my($this,$kernel,$heap,$arg) = @_;
  #$this->print("lost connection with the server\n");
  $this->{"connected"} = 0;
  $kernel->post($this->{"tcpalias"}, "shutdown");
}
#########################################################
=pod

=item print_ev

delegator for printing

=cut

#########################################################
sub print_ev
{
  my ($this,$msg,$kernel,$origin) = @_[OBJECT,ARG0, KERNEL,ARG1];

  $origin = "torrent" if(!$origin);
  if($this->{"redirectPrint"})
  {
    my $handler = $this->{"printhandler"};
    my @request = ( 
	[ "print", { "msg" =>$msg, "origin" => "torrent"} ]
	);
    #reset the listing of pages to seach, since we are asking for a whole new bunch of pages...
    my $job = {
      "requests" => \@request,
    };
    $kernel->yield("pushToServer", $job);
  }# if($this->{"printhandler"})
  else
  {
    print("$msg\n");
  }
}# sub print
#########################################################
=pod

=item print

local delegator for printing

=cut

#########################################################
sub print
{
  my ($this,$msg) = @_;

  print("gui::connector $msg\n");
}# sub print
#########################################################
=pod

=item setting 

setter/getter for the settings, to be able to choose any format for those
settings without disturbing the rest of the program...

=cut

#########################################################
sub setting 
{
  my ($this,$key,$value) = @_;
  if(!$value)
  {

    return $this->{"subsettings"}->{$key} if($this->{"subsettings"}->{$key});
    return $this->{"settings"}->{$key};
  }# if ($key)
  $this->{"subsettings"}->{$key} = $value;
}#setting
1
__END__


=back

=head1 SEE ALSO

http://poe.perl.org/

=cut

