##############################################################################
=pod

=head1 NAME

downloader

=head1 DESCRIPTION

react on DCC SEND requests, accept the file and download it to 'download'
directory with temporary storage in 'tmpfiles'

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  downloader.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::downloader;
use strict;
use zebot::baseactor;
use Data::Dumper;
#use ObjectTemplate;
use POSIX qw(strftime);
use File::Copy;

our @ISA = ("zebot::baseactor");
zebot::baseactor::_define_constructor("zebot::downloader");

#####################################################################
=pod

=item init

initialize this element, notably make the connection to the database

=cut

#####################################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;
   my $sysrefe = $sysref;
   # $this->print("obj = $this\n");
   # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");
  $this->SUPER::init($sysref);
   $this->sysdata($sysref);
   $this->setting("download","incoming/") if(!($this->setting("download")));
   $this->setting("tmpfiles","tmp/") if(!($this->setting("tmpfiles")));
}#sub init

#####################################################################
=pod

=item help

issue the help for this module

=cut

#####################################################################
sub help
{
   my ($this,$args) = @_;
  my $msg =  $this->sysdata()->getMesg("DOWNLOADERHELP",$args);
  return $msg;
}#sub help

#####################################################################
=pod

=item isa

issue the type of this module

=cut

#####################################################################
sub isa
{
  return "downloader";
}#sub isa

#####################################################################
=pod

=item version

issue the version of this module

=cut

#####################################################################
sub version
{
  return '$Revision: 1.5 $';
}#sub isa

#####################################################################
=pod

=item shutdown

close operations, save evenutally necessary data, remove datastructeres etc.

=cut

#####################################################################
sub shutdown
{
   my $this = shift;
  my $owner = $this->setting("owner");
}#sub shutdown
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
#########################################################
=pod

=item irc_dcc_request

react on some dcc transfer/chat proposal

 You receive this event when another IRC client sends you a DCC SEND
 or CHAT request out of the blue. You can examine the request and
 decide whether or not to accept it here. ARG0 is the nick of the
 client on the other end. ARG1 is the type of DCC request (CHAT,
 SEND, etc.). ARG2 is the port number. ARG3 is a "magic cookie"
 argument, suitable for sending with 'dcc_accept' events to signify
 that you want to accept the connection (see the 'dcc_accept' docs).
 For DCC SEND and GET connections, ARG4 will be the filename, and
 ARG5 will be the file size.
=cut

#########################################################
sub DCCrequest
{
  my ($this, $args) = @_;
  # my $subargs = {
  #   "kernel" => $kernel,
  #   "heap" => $heap,
  #   "network" => $heap->{"network"},
  #   "usernick" =>$nick,
  #   "username" =>$name,
  #   "userhost" =>$host,
  #   "magic" =>$magic,
  #   "type" =>$type,
  #   "file" =>$filename,
  #   "port" =>$port,
  #   "size" =>$size,
  #   "context" =>$tmpServer, #this one holds the link to the actual server, can be used as post target
  #  };
  my $kernel = $args->{"kernel"};

    my $filename = lc($args->{file});
    $filename =~ s/\s+/_/g;

    my $copy = $filename;
    my $counter = 1;
   my $incdir = $this->setting("download");
   $incdir .= "/" if(!($incdir =~ /\/$/));

    while(-f $incdir.$filename)
    {
      $filename = $copy."_$counter";
      $counter++;
    }# while(-f $filename)

   my $tmpdir = $this->setting("tmpfiles");
   $tmpdir .= "/" if(!($tmpdir =~ /\/$/));

    $filename = $tmpdir.$filename;


  #print "Downloader::DCCrequest received $args->{type}\n";
  if($args->{type} =~ /SEND/i)
  {
    #print "Downloader::DCCrequest send recognized allowing it\n";
    my $msg = "from:".$args->{usernick};
    $msg .= " magic:".$args->{magic};
    $msg .= " file:".$args->{file};
    $msg .= " size:".$args->{size};
    print "$msg \n";
    $this->{"transfers"}->{$args->{usernick}}->{$args->{file}} =
    { "magic" => $args->{magic}, "size" => $args->{size},
      "name" => $filename};

    #$this->post( $usernick,$msgHand->getMesg("PAMPASSHELP",$splittedline));
    #print("checkign for file  ".$filename."\n");
    if(my $filesize = -s $filename)
    {
      #print("resuming!!!!!\n");
      my $msg = $args->{file}." ".$args->{port}." $filesize";
      $args->{magic}->{"tmpfile"} = $filename;
      #print("Dumping cookie: ".Dumper($args->{magic})."\n");
      print("sending dcc_resume with $filename \n");
      $args->{heap}->{cookies}->{$args->{file}} = $args->{magic};
      $kernel->post( $args->{context}, 'dcc_resume', $args->{magic}, $filename, $filesize);
      
    }# if(-f $tmpdir.$filename)
    else
    {
      #print("new file!!!!!\n");
      $kernel->post( $args->{context}, 'dcc_accept', $args->{magic}, $filename);
    }

  }# if($args->{type} =~ /SEND/i)
  elsif($args->{type} =~ /ACCEPT/i)
  {
  #$args->{magic}->{type} = "SEND";
	#print("Dumping cookie: ".Dumper($args->{magic})."\n");
      print("sending dcc_ACCEPT with $filename \n");
      $kernel->post( $args->{context}, 'dcc_accept', $args->{magic}, $filename);
      print("posted accept\n");
  }
}# sub irc_dcc_request 
##############################################################################
=pod

=item DCCget

intermediary success of a running transfer

=cut

##############################################################################
sub DCCget
{
  my ($this,$args) = @_;
  #my $subargs = {
  #  "kernel" => $kernel,
  #  "heap" => $heap,
  #  "network" => $heap->{"network"},
  #  "usernick" =>$nick,
  #  "username" =>$name,
  #  "userhost" =>$host,
  #  "magic" =>$magic,
  #  "file" =>$file,
  #  "port" =>$port,
  #  "size" =>$size,
  #  "done" =>$done,
  #  "context" =>$_[SENDER], #this one holds the link ot the actual server, can be used as post target
  #};
  #print "Downloader::DCCget received $args->{type}\n";
  #if($args->{type} =~ /SEND/i)
  #{
  #  print "Downloader::DCCrequest send recognized allowing it\n";
  #  my $msg = "from:".$args->{usernick};
  #  $msg .= " magic:".$args->{magic};
  #  $msg .= " file:".$args->{file};
  #  $msg .= " size:".$args->{size};
  #  print "$msg \n";
  #  $this->{"transfers"}->{$args->{usernick}}->{$args->{file}} =
  #  { "magic" => $args->{magic}, "size" => $args->{size},
  #    "name" => $filename};

  #  #$this->post( $usernick,$msgHand->getMesg("PAMPASSHELP",$splittedline));
  #  $kernel->post( $args->{context}, 'dcc_accept', $args->{magic});

  #}# if($args->{type} =~ /SEND/i)
}#sub DCCget
##############################################################################
=pod

=item DCCdone

success of a dcc transfer

=cut


##############################################################################
sub DCCdone
{
  my ($this,$args) = @_;

  # my $subargs = {
  #   "kernel" => $kernel,
  #   "heap" => $heap,
  #   "usernick" =>$nick,
  #   "username" =>$name,
  #   "userhost" =>$host,
  #   "magic" =>$magic,
  #   "type" =>$type,
  #   "file" =>$file,
  #   "port" =>$port,
  #   "network" => $heap->{"network"},
  #   "size" =>$size,
  #   "done" =>$done,
  #   "context" =>$_[SENDER], #this one holds the link ot the actual server, can be used as post target
  # };
  print("DCC success for ".$args->{file}."\n");
  my @path = split('/',$args->{file});
  my $filename = pop(@path); 
  print("DCC success filename $filename\n");
   my $incdir = $this->setting("download");
   $incdir .= "/" if(!($incdir =~ /\/$/));
  move($args->{file},$incdir.$filename);
}#sub DCCdone
##############################################################################
=pod

=item DCCerror

failure of a dcc transfer

=cut

##############################################################################
sub DCCerror
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  return 0 if(!($this->activeForThisChan($args)));
  return 1;
}#sub DCCerror
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

