##############################################################################
=pod

=head1 NAME

XML parser

=head1 DESCRIPTION

XML parser to read in the emotes and command files for the messageHandler
notably

=head1 COPYRIGHT

Copyright (c) 2002 Bruno Boettcher

=head1 LICENCE

  emoteparser.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::emoteparser;
use strict;

use Data::Dumper;
use XML::Parser;
#use ObjectTemplate;
#@ISA = ("ObjectTemplate");
#attributes("sysdata");

my $tokenTree = {};
my $langTree = {};
my $actTok = {};
my $actLang = {};
my @refStack = ();
my $tokenName ="";
my $actReply ="";
my $actText ="";

##############################################################################
=pod

=item CTOR

instantiation of the emoteparser

=cut

##############################################################################
sub new {
  my $this = bless {}, "zebot::emoteparser";
  return $this;
}
##############################################################################
=pod

=item init

initialisation of the emoteparser

=cut

##############################################################################
sub init
{
  my ($this,$botref) = @_;
  #print "emoteparser::".$this->isa()." init\n";
  $this->{"parser"} = new XML::Parser(
      #Style => 'Debug',
      #Style => 'Subs',
      Style => 'Subs',
      Pkg => 'zebot::emoteparser',
      ErrorContext => 3,  #num of lines around the error
      );
  $this->{"parser"}->setHandlers(Char    => \&text,
                                Default => \&other);

  return 0;
}#sub init
##############################################################################
=pod

=item parse

takes a filename and the 2 references to the translation tables,  and parses
it, you need 2 since you surely want to go in both directions, means tag to
message, and trigger to tag... you can use both independently, since they share
the actual languge definition hash...  don't forget to initalize the refs since
the sub fills them, if there were undef, they will be lost...

=cut

##############################################################################
sub parse
{
  my ($this,$filename,$tTree,$lTree) = @_;
  
  $tokenTree = {};
  $langTree = {};

  $tokenTree = $tTree if($tTree);
  $langTree = $lTree if($lTree);

  my $parser = $this->{"parser"};
  #print("emoteParese: start parse $filename\n");
  $parser->parsefile($filename);
  #print("emoteParese: tokens ".Dumper(keys(%{$tokenTree}))."\n");
  return [$tokenTree,$langTree];
}#sub shutdown
##############################################################################
=pod

=item isa

issue the type of this object

=cut

##############################################################################
sub isa
{
  return "emoteparser";
}#sub isa
##############################################################################
=pod

=item version

issue the version of this module

=cut

##############################################################################
sub version
{
  return '$Revision: 1.8 $';
}#sub isa
#########################################################
=pod

=item debug

issue debugging messages to the console

=cut

#########################################################
sub debug
{
  my ($this,$msg) = @_;
  $msg = $this if(!$msg);
  print("$msg\n");
}# sub debug
#########################################################
=pod

=item emote

Callback for an opening emote tag

Is the first useful tag of the emotes env, since it holds the definition for
one type of reactions

=cut

#########################################################
sub emote
{
 #print "start of emote : ".Dumper(@_)."\n"; 
  my ($expat, $envname, $tok,$tag) = @_;
  $tokenName = $tag;
  #print "START of emote : $tag\n"; 
  $tokenTree->{$tag} = {} if(!($tokenTree->{$tag}));
  $actTok = $tokenTree->{$tag};
  shift;shift;shift;shift;
  while(@_)
  {
    my $tok = shift,
    my $arg = shift;
    $actTok->{$tok} = $arg;
  }# while(@_)
}# sub emote
#########################################################
=pod

=item emotes


this is invoqued when the starting tag of the emotes env is called

=cut

#########################################################
sub emotes
{
  #print("begin parsing:".Dumper($tokenTree)."\nend\n");
}# sub emotes
#########################################################
=pod

=item emotes_


this is invoqued when the ending tag of the emotes env is called

=cut

#########################################################
sub emotes_
{
  #print("finished parsing:".Dumper($tokenTree)."\nend\n");
  #print("finished parsing dumping langtree:".Dumper($langTree)."\nend\n");
}# sub emotes_
#########################################################
=pod

=item lang

Begin of a language specific section, now come for a given tag the different
planned reactions

=cut

#########################################################
sub lang
{
  my ($expat, $envname) = @_;
  shift;shift; #remove those 2 args from the stack

  my $args = { };
  while(@_)
  {
    my $tok = shift,
    my $arg = shift;
    $args->{$tok} = $arg;
  }# while(@_)
  my $langname = $args->{"name"};
  $actTok->{$langname}->{"trigger"} = $args->{"trigger"};
  #save the actual ref of the ressource
  push(@refStack,$actTok);
  $actTok->{$langname}->{"modes"} = {} if(!($actTok->{$langname}->{"modes"}));

  #we stored the thing in tokenTree, now we need to setup the copy for the langtree
  if(!($langTree->{$langname}))
  {
    $langTree->{$langname} = {};
  }# if(!($langTree->{$langname}))

  $actTok = $actTok->{$langname}->{"modes"};
  if($args->{"trigger"})
  {
  $langTree->{$langname}->{$args->{"trigger"}} = $actTok;
  $langTree->{$langname}->{$args->{"trigger"}}->{"token"} = $tokenName;
  }# if($args->{"trigger"})
}# sub lang
#########################################################
=pod

=item lang_

exiting the lang env, mainly to reset the setting to a state where the next
lang section finds a clean env

=cut

#########################################################
sub lang_
{
  #restore  the correct context 
  $actTok = pop(@refStack);
  #print("end lang\n");
}# sub lang_
#########################################################
=pod

=item mode

last part of the emotes parsing, here we have one line per type of reaction per
type of user

=cut

#########################################################
sub mode
{
  my ($expat, $envname) = @_;
  shift;shift; #remove those 2 args from the stack

  my $args = { };
  while(@_)
  {
    my $tok = shift,
    my $arg = shift;
    $args->{$tok} = $arg;
  }# while(@_)
  #print("Modeline: args=".Dumper($args)." act line =".Dumper($actTok)."\n");
  $actTok->{$args->{"type"}}->{"reply"} = $args->{"reply"} if($args->{"reply"});
  $actTok->{$args->{"type"}}->{"action"} = $args->{"action"} if($args->{"action"});
  $actTok->{$args->{"type"}}->{"command"} = $args->{"command"} if($args->{"command"});
  $actReply = $actTok->{$args->{"type"}};
  #print("set actReply to ".Dumper($actReply)."\n");
}# sub mode
#########################################################
=pod

=item mode_

close the mode parsing, append to reply any dangling text and clear that buffer

=cut

#########################################################
sub mode_
{
  my ($expat, $envname) = @_;

  $actText =~ s/\s+/ /g;
  $actReply->{"body"} = $actText if(!($actText =~ /^\s*$/));
  $actText = "";
  #print("Dumping the actual reply:".Dumper($actReply)."\n");
}# sub mode_
#########################################################
=pod

=item text

some raw text comes in, store it and let the elements handle that...

=cut

#########################################################
sub text
{
  my ($expat, $data) = @_;
  $data =~ s/
/ /g;
  $data =~ s/\s+/ /g;
  #if(!($data =~ /^\s*$/))
  #{
  #  print("PARSER::text with '$data' '$expat'\n");
  #}
  $actText .= "$data ";
}# sub text
#########################################################
=pod

=item other

some unkown text comes in, store it and let the elements handle that...

=cut

#########################################################
sub other
{
  my ($expat, $data) = @_;
  #print("PARSER::other with '$data' '$expat'\n");
  $data =~ s/
//g;
  $actText .= "O$data O " if(!($data =~ /^\s*$/));
}# sub other
1
__END__


=back

=head1 AUTHOR 

Bruno BTTCHER <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
Net::IRC, 
RFC 1459,
http://www.irchelp.org/, 
http://poe.perl.org/
http://www.cs.cmu.edu/~lenzo/perl/, 
http://www.infobot.org/,


=cut

