##############################################################################
=pod

=head1 NAME

Signal module

=head1 DESCRIPTION

Module handling the signal events of the client

=head1 COPYRIGHT and LICENCE

Copyright (c) 2002 Bruno Boettcher

Signals.pm is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################



package zebot::gui::Signals;
use strict;

use zebot::gui::Gui;

my %Signals = ( Server => { "eof" => \&signal_eof } );


##############################################################################
=pod

=item signal_emit

Emits a signal (call the respective callback)

=cut

##############################################################################

sub signal_emit {
	my $self = shift;
	my($signal) = @_;
	
	$Signals{ref($self)}{$signal}->($self);
}



##############################################################################
=pod

=item signal_eof

EOF signal callback

=cut

##############################################################################

sub signal_eof {
	my $self = shift;
	$self->{sock} = undef;
	
	$main::status->{list}->remove_item($self->{host});
}
