##############################################################################
=pod

=head1 NAME

mailbox

=head1 DESCRIPTION

record message to other users and serve them to them , immediately or when
  they connect again

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  mailbox.pm  is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::mailbox;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);

our @ISA = ("zebot::baseactor");
#attributes("messages","deb");
zebot::baseactor::_define_constructor("zebot::mailbox");

######################################################################
=pod

=item init

initalize the object

=cut

######################################################################
sub init
{
  my @securedargs = @_;
  my $this = shift;
  my $sysref = shift;
  my $sysrefe = $sysref;
  #$this->print "obj = $this\n";
  #$this->print "syse[botname] = ".$sysrefe{"botname"}."\n";
  $this->SUPER::init($sysref);
  $this->sysdata($sysref);
  my $ref = {};
  $this->messages($ref);
  $sysref->module("mailbox",$this);
}#sub init
######################################################################
=pod

=item PRIVMSGaction

propose the mail-command

=cut

######################################################################
sub PRIVMSGaction
{
   my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $botname = $splittedline->{"heap"}->{"nick"};
   my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

   #$this->print "debug '$botname': received $line\n";
   my $line = $splittedline->{"line"}; 
   if($line =~ /$botname\s*:\s*mail (\S+)\s+(.*)$/)
   {
      my $sender = $splittedline->{"usernick"}; 
      my $email = $splittedline->{"userhost"}; 
      my $receiver = $1;
      my $msg = $2; 
      #$this->print "debug '$botname': line is ok, msg= $msg from $sender to $receiver\n";
      #$this->print "debug '$botname': retrieving for $receiver\n";
      my $actMsg = $this->setting($receiver);
      #$this->print "actMsg now= ";
      #foreach $i (@$actMsg){$this->print $i.",";}
      #$this->print "\n";
      #my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = gmtime(time);
      my $now_string = strftime "%a %b %e %H:%M:%S %Y", gmtime;
      $now_string .= " : ".$msg." by ".$sender."\n";
      
      push(@$actMsg,$now_string);
      #$this->print "debug '$botname': pushed $now_string\n";
      #$this->print "debug '$botname': pushing for $receiver\n";
      $this->setting($receiver,$actMsg);
      $this->post($sender,$this->sysdata()->getMesg("MAILRECORDED",$splittedline)." $now_string");
      #foreach $i (@$actMsg){$this->print "deb1:".$i."\n";}
      #$actMsg = $this->setting($receiver);
      #$this->print "count = ".$#{@$actMsg}."\n";
      #foreach $i (@$actMsg){$this->print "deb22:".$i."\n";}
      return 1;
   }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
   return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item JOINaction

someone joins, check if we don't have a message for him, deliver in case

=cut

######################################################################
sub JOINaction
{
   my ($this,$sLine) = @_;
  return if($this->SUPER::activeForThisChan($sLine));
   my $kernel = $sLine->{"kernel"};
  $this->{"kernel"} = $sLine->{"kernel"};
  $this->{"context"} = $sLine->{"context"};

    my $usernick = $sLine->{"usernick"};
    my $username = $sLine->{"username"};
    my $userhost = $sLine->{"userhost"};
    
    if( $this->setting($usernick))
    {
      my $actMsg = $this->setting($usernick);
      #$this->action($usernick,$this->sysdata()->getMesg("MAILBRING",$sLine)'brings a note, written on it:');
      $this->action($usernick,$this->sysdata()->getMesg("MAILBRING",$sLine));
      foreach my $msg ( @$actMsg )
      {
      $this->post($usernick,$msg);
      }#foreach $msg ( @actMsg )
      $actMsg = [];
      $this->setting($usernick,$actMsg);
    }#if( @actMsg = $usernick)
    #my $reconstructed = $usernick." is ".$username."@".$userhost;
    #SendServer( 'PRIVMSG '.$channel.' : ouaf ouaf  '.$reconstructed );
    return 0;
}#sub JOINaction
######################################################################
=pod

=item help

issue the help for the usage of this module

=cut

######################################################################
sub help
{
   my ($this,$splitline) = @_;
  my $botname = $splitline->{"heap"}->{"nick"};
  return "Mailbox:\n    msg ".$botname." mail nick message";
}#sub help
######################################################################
=pod

=item isa

issue the type of this module

=cut

######################################################################
sub isa
{
  return "mailbox";
}#sub isa
######################################################################
=pod

=item version

issue the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.19 $';
}#sub isa
######################################################################
=pod

=item messages

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub messages
{
  my($this,$lmessages);
  if($lmessages)
  {
      $this->{"messages"} = $lmessages;
  }
  return $lmessages;
}# sub messages

1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

