##############################################################################
=pod

=head1 NAME

operators_pam

=head1 DESCRIPTION

operator module, op, deop etc users on a given channel
using the pam authentification

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  operators_pam.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::operators_pam;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use Data::Dumper;
use POSIX qw(strftime);
use DBI;

# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

use POE::Session;

our @ISA = ("zebot::baseactor");
#attributes("operators_pam","deb");
zebot::baseactor::_define_constructor("zebot::operators_pam");

#########################################################
=pod

=item init

initalize the module

=cut

#########################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;

  $this->{"automodes"} = {};
  $this->SUPER::init($sysref);
   $this->sysdata($sysref);
}#sub init

#########################################################
=pod

=item PRIVMSGaction

propose the commands seen to display the last visit of a given user

=cut

#########################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $botname = $splittedline->{"heap"}->{"nick"};
  #$this->print "debug '$botname': received $line\n";
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  my($command, $evChan, $rest) = split(/ /,$line,3);
  if($evChan && $evChan =~ /^#/)
  {
    $splittedline->{"channel"} = $evChan;
    $line = $rest;
  }# if($evChan =~ /^#/)
  else
  {
    $line = $evChan;
    if($rest) {$line .= " ".$rest;}
  }# else
  #$this->print "findOp, req by $usernick $username\@$userhost\n";
  #$this->print "full-line was ".$splittedline->{"fulline"}."\n";
  #$this->print "findOp, botname='$botname'\n";
  #$this->print "findOp, restline='$line'\n";
  my $pam = ($this->sysdata())->module("pam");

  if ($command=~ /\s*seen/i )
  {
    my $user = $line;
    #$this->print("CALLING GETLOGGED \n");
    my $msg = $pam->getLogged($usernick,$user);
    $pam->post($msg);
    #$this->print("GETLOGGED returned:".$msg."\n");
    #my @helplines = split(/\n/,$msg);
    #foreach $i (@helplines)
    #{
      #  chomp $i;
      #  $kernel->post( $splittedline->{"context"}, 'privmsg', $usernick,$i);
      #}# foreach $i (@helplines)
    return 1;
  }# elsif ($restLine=~ /\s*(\S+)\s*(.*)/ )
  return 0;
}#sub PRIVMSGaction
#########################################################
=pod

=item JOINaction

react on some user joining the channel

=cut

#########################################################
sub JOINaction
{
  #$this->print("someone joins...\n");
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  #$this->print("we are active ...\n");

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  my $channel = $splittedline->{"channel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};



  my $pam = ($this->sysdata())->module("pam");
  #$this->print "m5: search for $usernick\n";
  $splittedline->{"noauth"} = 1;
  my $list = $pam->findOperator($splittedline);

    if(!$list)
    {
      $this->triggerAutomode($channel,$splittedline);
      return 0; 
    }# if(!$list)


  #$this->print("rights of this user: $list\n");
  my $msgHand = ($this->sysdata())->module("messageHandler");
  #my $actLang = $msgHand->fetchChannelLang($channel);
  my $actLang = $splittedline->{"lang"};
  $splittedline->{"lang"} = $actLang;
  $splittedline->{"lang"} = $actLang;
  #$this->print "m51: found $list\n";
  if($list =~ /owner/i)
  {
    $splittedline->{"mode"} = "owner";
    my $msg = $msgHand->getMesg("OPERATORGREET",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'places at feet of his god: '.$usernick);
    #$this->print("issuing: ".$splittedline->{"channel"}.' +o '.$usernick."\n");
    $splittedline->{"mode"} = ' +o ';
    #$this->mode( $kernel,$splittedline->{"channel"},' +o '.$usernick);
    $this->mode( $splittedline);
    return 0;
  }#if($list ne "")
  elsif(index($list,"oper") != -1) 
  {
    #$this->print("its an oper!!!\n");
    $splittedline->{"mode"} = "oper";
    my $msg = $msgHand->getMesg("OPERATORGREET",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'dances around '.$usernick);
    #$this->mode( $kernel,$splittedline->{"channel"},'+o '.$usernick);
    $splittedline->{"mode"} = ' +o ';
    $this->mode($splittedline);
    return 0;
  }#if($list ne "")
  elsif(index($list,"ally") != -1) 
  {
    $splittedline->{"mode"} = "ally";
    my $msg = $msgHand->getMesg("OPERATORGREET",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->post($splittedline->{"channel"},$msg);
    #$this->print("its an ally!!!\n");
    #$this->post($splittedline->{"channel"},'ouaf ouaf '.$usernick);
    return 0;
  }#if($list ne "")
  elsif(index($list,"teki") != -1) 
  {
    $splittedline->{"mode"} = "teki";
    #$this->print("its an teki!!!\n");
    my $msg = $msgHand->getMesg("MORDS",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'bites a big piece out of '.$usernick.'\'s private parts');
    $splittedline->{"mode"} = ' -o ';
    $this->mode( $splittedline);
    #$this->mode( $kernel,$splittedline->{"channel"},'-o '.$usernick);
    return 0;
  }#if($list ne "")

   $this->triggerAutomode($channel,$splittedline);
  return 0;
}#sub JOINaction
#########################################################
=pod

=item PARTaction

react on some user leaving the channel

=cut

#########################################################
sub PARTaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  my $channel = $splittedline->{"channel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  my $pam = ($this->sysdata())->module("pam");
  my $msgHand = ($this->sysdata())->module("messageHandler");
  #my $actLang = $msgHand->fetchChannelLang($channel);
  my $actLang = $splittedline->{"lang"};
  #$this->print "m5: search for $usernick\n";
  $splittedline->{"lang"} = $actLang;
  $splittedline->{"noauth"} = 1;
  my $list = $pam->findOperator($splittedline);
  return 0 if(!$list);
  #$this->print "m51: found $list\n";
  if(index($list,"owner") != -1) 
  {
    $splittedline->{"mode"} = "owner";
    my $msg = $msgHand->getMesg("OPERATORPART",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'AAAouuuuuuuuuuuuuuhhhh!!!');
  }#if($list ne "")
  elsif(index($list,"oper") != -1) 
  {
    $splittedline->{"mode"} = "oper";
    my $msg = $msgHand->getMesg("OPERATORPART",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'Fiiiiiii!!! '.$usernick);
  }#if($list ne "")
  elsif(index($list,"ally") != -1) 
  {
    $splittedline->{"mode"} = "ally";
    my $msg = $msgHand->getMesg("OPERATORPART",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'fiiiiiii!!! '.$usernick);
  }#if($list ne "")
  elsif(index($list,"teki") != -1) 
  {
    $splittedline->{"mode"} = "teki";
    my $msg = $msgHand->getMesg("OPERATORPART",$splittedline);
    $msg =~ s/%target/$usernick/g;
    $this->action($splittedline->{"channel"},$msg);
    #$this->action($splittedline->{"channel"},'Waf Waf!! '.$usernick);
  }#if($list ne "")
  return 0;
}#sub PARTaction
#########################################################
=pod

=item help

issue the help and usage messge for this module

=cut

#########################################################
sub help
{
  my $this = shift;
  my $splittedline = shift;
  my $botname = $splittedline->{"heap"}->{"nick"};
  #$this->print "m6: search for $usernick\n";
  #$this->print "ref = '$splittedline'\n";
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $channel = $splittedline->{"channel"};

  my $msgHand = ($this->sysdata())->module("messageHandler");
  #my $actLang = $msgHand->fetchChannelLang($channel);
  my $actLang = $splittedline->{"lang"};
  #$splittedline->{"lang"} = $actLang;

  my $pam = ($this->sysdata())->module("pam");
  #$this->print "m5: search for $usernick\n";
  my $list = $pam->findOperator($splittedline);
  #$this->print "m51: found $list\n";
  #$this->print "help, req by $usernick $username\@$userhost\n";
  #$this->print "full-line was ".$splittedline->{"fulline"}."\n";
  my  $helpmsg = "";
  $helpmsg = $msgHand->getMesg("OPERATORHELPTITLE",$splittedline).":\n";
  #$helpmsg .= $this->dumpLangs();
  if(index($list,"owner") != -1 || index($list,"oper") != -1) 
  {
    #$helpmsg   .= "   no commands available\n";
    $helpmsg .= $msgHand->getMesg("NOCMDS",$splittedline)."\n";
  }#if($list ne "")
  else 
  { 
    $helpmsg .= $msgHand->getMesg("PAMNOAUTH",$splittedline)."\n";
    #$helpmsg .= "user $usernick, $username\@$userhost is not ";
    #$helpmsg .= "Operator, help not available!\n";
    #$helpmsg .= "result query gave: $list";
  }
  $helpmsg =~ s/%sender/$usernick/g;
  $helpmsg =~ s/%name/$username/g;
  $helpmsg =~ s/%host/$userhost/g;
  return $helpmsg;
}#sub help
#########################################################
=pod

=item isa

issue the type of this module

=cut

#########################################################
sub isa
{
  return "operators_pam";
}#sub isa
#########################################################
=pod

=item shutdown

prepare the module for its imminent death

=cut

#########################################################
sub shutdown
{
   my $this = shift;
  my $owner = $this->setting("owner");
}#sub shutdown
#########################################################
=pod

=item version

issue the version of this module

=cut

#########################################################
sub version
{
  return '\$Revision: 1.21 $';
}#sub isa
#########################################################
=pod

=item sysdata

setter/getter for the preferences hash coming from the skeleton

=cut

#########################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
#########################################################
=pod

=item setting 

setter/getter for the settings, to be able to choose any format for those
settings without disturbing the rest of the program... when getting it tries
the local hash first, if it matches that value is returned, if not the call is
propagaed to the mainframe. On set it is checked if that setting exists
globally, if yes its propagated, if not its set locally, BEWARE this means you
can't set new settings on the mainframe through this method!

=cut

#########################################################
sub setting 
{
  my ($this,$key,$value) = @_;

  my $botref =  $this->{"zebot"};

  if(!$key)
  {
      my $res;
      foreach my $chan (sort(keys(%{$this->{"automodes"}})))
      {
         $res .= $chan.":".$this->{"automodes"}->{$chan}." ";
      }# foreach my $mode (sort(keys(%{$this->{"automodes"}})))
    my $msg = $this->SUPER::setting($key,$value);
    $res = $msg."\n$res\n" if($msg);
    return($res);
  }# if(!$key)

  if($key eq "automode")
  {
    if($value)
    {
      my @batch = split(/\s+/,$value);

      foreach $value (@batch)
      {
	my ($channel, $mode) = split(/:/,$value);
	if($channel)
	{
	  $channel = "#$channel" if(!($channel =~ /^#/));
	  if($mode)
	  {
	    $this->{"automodes"}->{$channel} = $mode;
	  }# if($mode)
	  else
	  {
	    delete($this->{"automodes"}->{$channel});
	  }# else
	}# if($channel)
      }# foreach $value (@batch)
    }# if($value)
    else
    {
      my $res;
      foreach my $chan (sort(keys(%{$this->{"automodes"}})))
      {
         $res .= $chan.":".$this->{"automodes"}->{$chan}." ";
      }# foreach my $mode (sort(keys(%{$this->{"automodes"}})))
      return($res);
    }# else
  }# if($key eq "automode")
  else
  {
    return($this->SUPER::setting($key,$value));
  }# else
}#setting
#########################################################
=pod

=item triggerAutomode

change eventually the mode of the user due to general settings as specified in
the config file or as set command:
toutouland:v 

means channel toutouland (# added if not present, do not add # in the config
file, they are interpreted as comments) with automode +v means voice

=cut

#########################################################
sub triggerAutomode
{
  my($this,$channel,$splittedline) = @_;
  my $automode = $this->{"automodes"}->{$channel};
  if($automode)
  {
    #print("automode activated!! changing to $automode\n");
    $splittedline->{"mode"} = ' +'.$automode;
    $this->mode($splittedline);
  }# if($automode)
  #else
  #{
    #    print("no automode activated... so far: ".Dumper($this->{"automodes"})."\n");
    #}
}#end triggerAutomode

### EOC
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

