#!/usr/bin/perl -w
##############################################################################
#  operator operations of the bot
#  author Bruno BTTCHER <bboett at adlp.org>
#  Copyright (c) 2002 Bruno Boettcher
#
# zebot is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################
sub POE::Kernel::ASSERT_EVENTS () { 1 };
sub POE::Kernel::ASSERT_STATES () { 1 };
sub POE::Kernel::ASSERT_DEFAULT () { 1 };
use POE::Kernel;
use POE::Session;
use Data::Dumper;
use XML::Simple;
use strict;
use zebot::test;

sub BEGIN
{
    #push (@INC,$ENV{HOME}.'/',$ENV{HOME}.'/ircbots')
    #      if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/ircbots/));
    #push (@INC,$ENV{HOME}.'/',$ENV{HOME}.'/ircbots/zebot')
    #      if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/ircbots\/zebot/));
    my $pwd = $ENV{PWD};
    my @fullpath = split('/',$pwd);
    pop @fullpath;
    my $pwdup = join('/',@fullpath);
    push (@INC,$pwdup)
          if(!( (join(' ',@INC)) =~ /$pwdup/));
    #we also need to include .., since our modules are searched in zebot/*
    #print "added $pwdup to path\n";
    push (@INC,$pwd)
          if(!( (join(' ',@INC)) =~ /$pwd/));
    #print "added also $pwd to path\n";
}
sub SendServer
{
  my $line = shift;
  print "SendServer: $line\n";
}#sub SendServer

my $settings = {
   "configpath" => "$ENV{HOME}/.zebot/",			#path to configfiles
           "botname" => "toutou",
           "owner" => "Lasade",
           "originhost" => "kalman.u-strasbg.fr",
           "fullname" => "Laureline de Monmarchel",
           "ircserver" => "irc.skroz.net",
           "streamName" => 'botlog',
           "reconnect" => 1,
           "operatorfile" => "users.conf",
           "channel" => "#toutouland",
           "emotesfile" => "zebot.emotes",
           "userfile" => "passwd",
           "actornames" => ["mailbox"],
           "reactionsfile" => "reactions.pl",
           "operationsfile" => "operations.pl",
   "ownerpass" => "toto",
   "xmlreactionsfile" => "res_emotes.xml",
   "xmlmessagesfile" => "res_messages.xml",
   "language" => "fr",
   "rejoininterval" => 60,
   "reconnectinterval" => 60,
   "debug" => 1,
           "instmodules" => {},
   "database" => 'DBI:Pg:dbname=zebot',
   "dbuser" => 'bboett'
               };

my $tester = new zebot::test();
print("tester is a ".ref($tester)."\n");
$tester->{"settings"} = $settings;
print("tester is still a ".ref($tester)."\n");
$tester->loadSettings(); 
print("tester is it? : ".ref($tester)."\n");

my %systemres;
$tester->{"modules"} = [];
$tester->{"actors"} = {};

#my $line = "<<-- :Lasade!~bboett\@serf-35315.cybercable.tm.fr PRIVMSG toutou :query first";
#my $line = "<<-- :Lasade!~bboett\@serf-35315.cybercable.tm.fr PRIVMSG toutou :query 1";
my $line = {
  "heap" => { "nick" => "toutou", "channels" => {"#toutouland" => 1}},
  "channel" => "#toutouland",
  "usernick" => "Lasade",
  "username" => "auser",
  "userhost" => "amchine",
  "lang" => "fr",
             "userhost"=>"serf-35315.cybercable.tm.fr",
             "command" => "PRIVMSG", 
             "fulline" => "whole line",
             "restLine"=> "toutou :mail aos test one" 
};
#use mailbox;
#$file = "dbaccess";
#$file = "mailbox";
#$file = "mailbox_pg";
#my $file = "operators";
#eval("use $file");
#my $cmd = 'new '.$file.'()';
#print "trying to eval $cmd\n";
#my $first = eval($cmd);
#use operators;
#my $first = new operators();
print "loading i8n\n";
use zebot::messageHandler;
my $MSobj = new zebot::messageHandler();
$tester->{"actors"}->{$MSobj->isa()} = $MSobj;
print "loading PAM\n";
use zebot::pam;
my $pam = new zebot::pam();
print "loading basereactions\n";
use zebot::basereactions;
my $BRobj = new zebot::basereactions();
print "loading mailbox_pg\n";
use zebot::mailbox_pg;
my $MBobj = new zebot::mailbox_pg();
print "loading operators_pam\n";
use zebot::operators_pam;
my $OPobj = new zebot::operators_pam();
#use download;
#my $DLobj = new download();
print "loading testmod\n";
use zebot::testmod;
my $TMobj = new zebot::testmod();
 print "loading baseactor\n";
 use zebot::baseactor;
zebot::baseactor::_define_constructor("zebot::baseactor");
 my $BAobj = new zebot::baseactor();

my $genObj = undef;
use zebot::dbaccess;
$genObj = new zebot::dbaccess();

use zebot::emoteparser;
$genObj = new zebot::emoteparser();

use zebot::fileserver;
$genObj = new zebot::fileserver();

use zebot::ircServer;
$genObj = new zebot::ircServer();

use zebot::mailbox;
$genObj = new zebot::mailbox();

use zebot::operators;
$genObj = new zebot::operators();

use zebot::operators_pg;
$genObj = new zebot::operators_pg();

use zebot::pam_pg;
$genObj = new zebot::pam_pg();

use zebot::triggers;
$genObj = new zebot::triggers();

#$settings->{"instmodules"} = {};
my $tempRef = $settings->{"instmodules"};
$tempRef->{"none"} = "toto";

my $sysref = $tester->{"settings"};
#print "YYYYYYYYY\n";
#print Dumper($systemres{"modules"});
#print "YYYYYYYYY\n";

$pam->init($tester);
print "BRobj inint:\n";
$BRobj->init($tester);
print "MBobj inint:\n";
$MBobj->init($tester);
print "OPobj inint:\n";
$OPobj->init($tester);
print "MSobj inint:\n";
$MSobj->init($tester);
#print "DLobj inint:\n";
#$DLobj->init($tester);
#print "TMobj inint:\n";
#$TMobj->init($tester);
#print "BAobj inint:\n";
#$BAobj->init($tester);

use zebot::dummypam;
$genObj = new zebot::dummypam();
print "DUMMYPAM inint:\n";
$genObj->init($tester);

use zebot::downloader;
$genObj = new zebot::downloader();
print "MEDOWN init:\n";
$genObj->init($tester);

use zebot::connector;
$genObj = new zebot::connector();
print "MECON init:\n";
$genObj->init($tester);

#print "dumping modules:\n";
#foreach my $i (keys(%{$settings->{"instmodules"}}))
#{
#  print("test: mod = $i ->".$settings->{"instmodules"}->{$i}."\n");
#}#foreach $i (keys(%$obj->sysdata()->{"instmodules"}))${*

print "here:".$pam->help($line)."\n";
print "next round\n";
$pam->PRIVMSGaction($line);
$line->{"fulline"} = "whole line";
$line->{"restLine"} = "toutou :mail aos test two";
$pam->PRIVMSGaction($line);
print "next round\nsending join!\n";
$line->{"fulline"} = "whole line";
$line->{"command"} = "JOIN"; 
$line->{"restLine"} = ":#fm";
$pam->JOINaction($line);
#print("finished parsing dumping langtree:".$MSobj->dumpLangs()."\nend\n");
print($MSobj->getMesg("FIRESERVHAND")."\n");
my $data = $MSobj->dumpXML();
foreach my $type (keys(%$data))
{
  print("XMLDUMP FOR $type:\n".$data->{$type}."\n");
}# foreach my $type (keys(%$data))
#$second->JOINaction($linec);
print "finished join \n";
#$pam->shutdown($pam,$linec);
$poe_kernel->run();
