package zebot::testLink;
use strict;
##############################################################################
=pod

=head1 NAME

testLink

=head1 DESCRIPTION

This  module is a helper for the zebot project, it represents a faked link to
test the behaviour of modules that need connection to some irc server

=head1 COPYRIGHT and LICENCE

Copyright (c) 2004 Bruno Boettcher

  zebot::testLink is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=head1 Methods of this class

=over

=cut

##############################################################################

use IO::Socket;
use Data::Dumper;

use POE::Kernel;
use POE::Session;

######################################################################
=pod

=item new 

constructor for the new irc-server handler object

=cut

######################################################################
sub new
{
  my ($this) = @_;
  my $o_FserverHandler = {

    "Status" 		=> undef,		# Our current fin. aut. state for nick
  };

  bless $o_FserverHandler, "zebot::testLink";
  return $o_FserverHandler;
}# sub new
#########################################################
=pod

=item init

prepare a connection with the ircserver

=cut

#########################################################
sub init
{
  my ($this,$name,$data,$botref) = @_;
  $this->{"name"} = $name;
  $this->{"zebot"} = $botref if( $botref);
  $this->{"channelLangs"} = {};
  my $arg = { "target" => $name, "line" => join(',',@{$data->{"channel"}})};
  print($botref->getMesg("SETIRCSERV",$arg)."\n");

  foreach my $record (keys(%$data))
  {
    $this->{$record} = $data->{$record};
  }# foreach my $record (keys(%$data))


  #add the active chans for this server to the global list
  #$botref->{"activeChans"} = "" if(!($botref->{"activeChans"}));
  $botref->{"activeChans"} .= " ".$this->{"activeChans"};
  $botref->{"activeChans"} =~ s/  / /gi;

  my @Chans = split (/,/,$this->{"activeChans"});

  foreach my $canal (@Chans)
  {
    $canal =~ /(.*?)%(.*?)%/;
    $canal = $1;
    my $lang = $2;
    $botref->language($canal,$lang);
    $this->{"channelLangs"}->{lc($canal)} = $lang;
    #$heap->{"channels"}->{"$canal"} = $lang;
    #print("SET lang $lang as default lang of $canal: dumping channel languages: ".Dumper($botref->{"channelLangs"}));

  }# foreach my $canal (@Chans)

  $this->{"zebot"} = $botref;
  my $server = $this->{"server"};

  $arg = {"target" => $server};
  print($botref->getMesg("CREATEIRCH",$arg)."\n");
  #########################################################
  # now add to this connection all sort of different handlers
  #########################################################

  #print("creating SESSION!!\n");
  #POE::Session->new( $name =>
      POE::Session->create( object_states => [ 

	$this =>
	{  _start => "_start",
	_stop  => "_stop",
	privmsg  => "privmsg",
	},
	],
	);
	#print "done add handler for $server\n";
	print($botref->getMesg("OKADDIRCHAND",$arg)."\n");
}# sub init
#########################################################
=pod

=item _start

start up operation concerning this irc server

=cut

#########################################################
sub _start 
{
  my ($this, $kernel, $session,$context, $network, $heap) = 
    @_[OBJECT, KERNEL, SESSION, SENDER, ARG0, HEAP];
  $heap->{"network"} = $this->{"name"};
  $heap->{"rejoins"} = {};
  #keep a reference on this session heap needed in reload
  $this->{"heap"} =  $heap;
  #print("initializing heap done: ".Dumper($heap)."\n");

  foreach my $canal (keys(%{$this->{"channelLangs"}}))
  {
    $heap->{"channels"}->{"$canal"} = $this->{"channelLangs"}->{"$canal"};
  }# foreach my $canal (@Chans)

  $kernel->alias_set( $this->{"name"} );

  $heap->{"nick"} = $this->{"nick"};
  $heap->{"botname"} = $this->{"nick"};
}# sub _start 
#########################################################
=pod

=item _stop

shut down operation concerning this irc server

=cut

#########################################################
sub _stop 
{
  my $kernel = $_[KERNEL];
  my  $context = $_[SENDER];
  my ($this) = @_;

  print $this->{"name"}." Control session stopped.\n";
  $kernel->post( $context, 'quit', 'Neenios on ice!' );
  $kernel->alias_remove( $this->{"name"} );
}
#########################################################
=pod

=item version

return the version of this module

=cut

#########################################################
sub version
{
    return '$Revision: 1.1 $';
}#sub isa
#########################################################
=pod

=item privmsg

start up operation concerning this irc server

=cut

#########################################################
sub privmsg 
{
  my ($this, $kernel, $session,$context, $network, $heap) = 
    @_[OBJECT, KERNEL, SESSION, SENDER, ARG0, HEAP];
  my $msg;
  foreach my $arg (ARG0..ARG4)
  {
   $msg .= " ".$_[$arg]."," if($_[$arg]); 
  }# foreach my $arg (ARG0..ARG4)
  print("fakeLink::privmsg got: $msg\n");
}# sub privmsg 
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

